/*
  <GHOUL/Config.scad>

  Hank J. van Leuvensteijn Jr. 2019
  hankjr@hankjr.ca

  This work is licensed under the Unlicense. Do with it as you please, it's not guaranteed to be good for or at anything, actually, it comes with a strict 'Un-Guarantee', declaring it to be fit for nothing at all. Use it at your peril. See License.txt in this directory. Go to <http://unlicense.org/> for more information.

  This is the universal GHOUL Header File , required for ALL OpenSCAD source-code files based on the GHOUL.

  This header include<>s 'Lib_All.scad' which in turn include<>s all GHOUL library files. OpenSCAD source-code files need only include this Config.scad' file to have access to the whole library.

  Other than that, this file is home to a few settings and a couple of functions that don't really fit anywhere else but belong everywhere...
*/

// Parameters and top level variable assignments ===============================
/* $Verbose is set to 'false' here, set $Verbose to 'true' in the top level source code to start verbose messaging.

When $Verbose=true, 'Echo()' declarations in functions and modules will provide 'run time' feedback in the console window.

An 'if($Verbose){}' construct can be used to selectively add explanatory or helper objects, or a text() object &c. */
$Verbose=false;

/* Some debugging calls are left in the code for convenience with future development in mind. Debug() is silent when '$Debug=false' so let's shut it up during normal run-time. */

$Debug=false;

/* Declare $AnimSegs, just in case. See 'Animation.scad' library. */
$AnimSegs=10;

// SEE COMMENTS IN Lib/Curves/Segments.scad
/* FIXED segment NUMBER for a full circle. */
$fn=0; // Default is 0, OpenSCAD recommends less than 128--lest you face CPU meltdown--unless you're reading this on a Cray XK6 terminal, of course... The GHOUL says: $fn SHALL be a multiple of 4, so corners of the $fn-agon (i.e. full radius) will fall on the cardinal points, giving a neater result when creating rounded corners for rectangular bodies &c.
/* MINIMUM segment SIZE of arcs and curves. */
$fs=0.4; // Default is 2; absolute minimum is 0.01 (OpenSCAD generates a warning if you're naughty). $fs only has influence when a circle or arc is _small_, so even small-ish values will not overly load your CPU. Your printer's resolution, or a small multiple thereof, is probably a good number...
/* MAXIMUM fragment, facet, or 'flat' on curves. */
$ff=0; // Default is 0, don't go _too_ small with this; love your CPU...
/* MINIMUM segment ANGLE of arcs and curves. */
$fa=6; // Default is 12, which is NOT a factor of 90, and thus NOT a preferred value*; absolute minimum is 0.01 (Yep, OpenSCAD complains for this one as well). For the same reason as stated above at $fn, The GHOUL prefers the factors of 90: [90, 45, 30, 18, 15, 10, 9, 6, 5, 3, 2, 1].
/* Curves are of cylindrical cross section. $fc is the facet _number_ used for this cross section, i.e., NOT the curvature of the curve itself, but the tubular form that makes up the curve. */
$fc=12;

/*
  We USED TO have nice html rendering in the console, splendid for making important output stand out from the dross.
  Then came 2021.01 and it was removed. Why? Sad. SMFH.
*/
/* Use 'Print()' to force messages even when '$Verbose=false'. */
/* Alert the user to Config output. */
Print([
    "\n\n",
    "### START CONFIG OUTPUT #############################\n",
    "# $Verbose = ",$Verbose,"\n",
    "# $Debug = ",$Debug,"\n",
    "# $AnimSegs = ",$AnimSegs,"\n",
    "# ViewPort = ",GetViewPort(),"\n",
    "# $fn = ",$fn,"\n",
    "# $fs = ",$fs,"\n",
    "# $fa = ",$fa,"\n",
    "# $ff = ",$ff,"\n",
    "# $fc = ",$fc,"\n",
    "# $fs to $fa cut-off radius is ",360/$fa*$fs/2/PI,".\n",
    "### END CONFIG OUTPUT ###############################",
    "\n\n"
],true); // Print() _should_ write to the console, but better be safe...

// Equipment settings ==========================================================

/* Manufacturing equipment (your printer) positioning precision, in native units, reduced by at least one order of magnitude. This is used, e.g., to avoid coinciding vertices &c., without affecting product dimensions to a _significant_ (real-world-measurable) degree. */
$EQ_Precision=0.01;

/* Machine (Your 3D printer) dependent specific production tolerance, in *native units*, for threads &c. This is a material reduction parameter to prevent poor fitment due to your printer's 'inaccuracies', i.e., this makes holes bigger, and shafts thinner. */
EQ_Allowance=0;

// Includes ====================================================================

/* All of the GHOUL in one fell swoop. If you prefer to load your libraries individually, comment the next line(s). */
include<TheGHOUL/Lib/Lib_All.scad>

/* Load the poor souls that remain "in Limbo". */
include<TheGHOUL/LimbusPuerorum.scad>

/* Keep your own additions, i.e., libraries, definitions, &c. related to TheGHOUL but not part of TheGHOUL itself in a separate directory. This way, it's easy to update TheGHOUL and leave your own stuff unaffected. */
include<TheGHOUL/Private/Private_All.scad>
include<TheGHOUL/Private/Cypher_All.scad>
