/*
  This file belongs in

  <TheGHOUL/DemoFiles/>

  Hank J. van Leuvensteijn Jr. 2021
  theghoul@hankjr.ca
*/

include<TheGHOUL/Config.scad>

/* OPEN THE ANIMATION VIEW WITH STEPS=100 AND FPS=10. */

// $AnimSegs is already set to 10 in Config.scad, see there.

// ball moving through a pattern -----------------------------------------------
Animate([0,0,5,],1)
translate([0,0,-20])
translate([20*pow(sin(180*$AnFrac),7),0,0])
translate([0,10+10*pow(sin(360*$AnFrac),3),0])
sphere(r=2);

// color changing words --------------------------------------------------------
Animate([0,0,10,])
color([0.5,$AnFrac,$AnFlash],$AnDip)
rotate([-15,0,5])
translate([0,0,0])
text("Hello World",size=2,font="Liberation Sans:style=Bold Italic");

// ball changing size and color ------------------------------------------------
Animate([1,1,9,9])
color("gold",$AnFlash)
translate([5,10,0])
sphere(r=3*$AnBounce);

// growing cylinder ------------------------------------------------------------
Animate([2,2,5,8])
rotate([0,90,0])
translate([0,20,0])
cylinder(r=1, h=10*$AnBump);

// turning gold cube -----------------------------------------------------------
Animate([0,0,1,])
translate([20,20,0])
rotate([0,0,180*$AnFlashing])
cube([5,5,5],center=true);

// tumbling red cube with varying transparency ---------------------------------
Animate([0,0,2,],1)
color("red",$AnFlashing
)
translate([20,10,0])
rotate([360*$AnTrngl,0,0])
rotate([0,0,60])
cube([5,5,5],center=true);

// tumbling cube with varying color --------------------------------------------
Animate([0,0,5,],1)
color([0.6,$AnTrngl,0.2])
translate([20,0,0])
rotate([90*$AnTrngl,-720*$AnTrngl,360*$AnTrngl])
cube([3,3,3],center=true);

