/*
  This file belongs in

  <TheGHOUL/DemoFiles/>

  Hank J. van Leuvensteijn Jr. 2021
  theghoul@hankjr.ca
*/

include<TheGHOUL/Config.scad>

/* OPEN THE ANIMATION VIEW WITH STEPS=100 AND FPS=10. */

$vpt=[0,0,0.5];
$vpr=[50,0,20];
$vpd=7;

//$AnimSegs=10; // already declared in Config.scad

// There isn't much to say about these. See Animate.scad for syntax etc.

// Select a demo
Select=1;

if(Select==1){
    Animate([0,3,10]) sphere(r=$AnBounce);
}

if(Select==2){
    Animate([0,3,10]) color("red",$AnFlash) cube([1,1,1]);
}

if(Select==3){
    Animate([0,3,9]) cylinder(r=0.5, h=$AnBump, $fn=36);
    color("yellow",0.2)
    cylinder(r=0.5, h=1, $fn=36);
}

if(Select==4){
    Animate([0,3,9]) rotate([0,0,180*$AnFlash]) cube([1,1,1]);
}

// Show the 'clock'
color("darkslategrey")
translate([0.25,-1,0.6])
rotate([90,0,0])
linear_extrude(0.01)
text(SetDecimals($AnimSegs*$t,2),size=0.2);
