/*
  This file belongs in

  <TheGHOUL/DemoFiles/>

  Hank J. van Leuvensteijn Jr. 2021
  theghoul@hankjr.ca
*/

include<TheGHOUL/Config.scad>


//CubicVsQuadratic();
module CubicVsQuadratic(){
    /*
      Factors for best approximation of 1/4 circle by Quadratic- and Cubic Bézier curves...
      'Factor' here means 'fraction of the radius'.
      C... for cubic parameters
      Q... for quadratic parameters
    */

    // Factors
    CF=0.552; // 0.552 gives a Root-Mean-Square-Error of 0.0013%
    QF=0.922; // 0.922 gives a Root-Mean-Square-Error of 0.54%

    // Pick a radius, anything over 20 shows the curve differences clearly.
    Radius=20;

    // Control points.
    CCCP=[[Radius,0],[Radius,CF*Radius],[CF*Radius,Radius],[0,Radius]];
    QCCP=[[Radius,0],[QF*Radius,QF*Radius],[0,Radius]];

    // Pick a resolution, anything over 20 yields a good data set.
    Resolution=40;

    // Curve vertices
    CC=BezierCurve(CCCP,Resolution);
    QC=BezierCurve(QCCP,Resolution);

    // Display the Bézier curves.
    color(RED)
    ShowCurve(CC,0.1);
    ShowCurve(QC,0.1);
    // The true circle.
    color(DSG)
    Arc(0,90,Radius,0.2,$fn=Resolution*4);

    // Root-Mean-Square and Mean Absolute errors from true circle.

    // Cubic errors
    CE=[for(CV=CC)
        pow(Modulus(CV)-Radius,2)
    ];
    CAE=[for(CV=CC)
        abs(Modulus(CV)-Radius)
    ];
    // Root-mean-square
    CRMSE=sqrt(ArraySum(CE)/len(CE));
    // Mean-absolute
    CMAE=ArraySum(CAE)/len(CE);

    // Quadratic errors
    QE=[for(QV=QC)
        pow(Modulus(QV)-Radius,2)
    ];
    QAE=[for(QV=QC)
        abs(Modulus(QV)-Radius)
    ];
    // Root-mean-square
    QRMSE=sqrt(ArraySum(QE)/len(QE));
    // Mean-absolute
    QMAE=ArraySum(QAE)/len(CE);

    // Publish data.
    Print(["\nCubic error = ",CMAE,
           "\nQuadratic error = ",QMAE,
           "\nError ratio = ",QMAE/CMAE,"\n"]);
}


// For animation, un-comment the next line. ====================================
//AnimSegs=10; View=ViewPort([[0,[7,10,0],[0,0,0],70],[2,[0,0,0],[0,0,0],120],[5,[0,0,0],[0,0,0],120],[7,[7,10,0],[0,0,0],70]]);$vpt=View[1];$vpr=View[2];$vpd=View[3];

// For image,  un-comment the next line. =======================================
VPT=[0,[0,0,0],[0,0,0],120];$vpt=VPT[1];$vpr=VPT[2];$vpd=VPT[3];

CubicQuarterVsHalfVsThreequarter();
module CubicQuarterVsHalfVsThreequarter(){

    /*
      QT = Quarter turn.
      HT = Half turn.
      TQT = Three-quarter turn.
    */

    // Factors
    QTF=0.552;
    HTF=1.33334;
    TQTF=2.85405;

    // Pick a radius, anything over 20 shows the curve differences clearly.
    Radius=20;

    // Control points.
    QCP=[[Radius,0],[Radius,QTF*Radius],[QTF*Radius,Radius],[0,Radius]];
    HCP=[[Radius,0],[Radius,HTF*Radius],[-Radius,HTF*Radius],[-Radius,0]];
    TQCP=[[Radius,0],[Radius,TQTF*Radius],[-TQTF*Radius,-Radius],[0,-Radius]];

    // Pick a resolution, anything over 20 yields a good data set.
    Resolution=40;

    // Curve vertices
    QC=BezierCurve(QCP,Resolution);
    HC=BezierCurve(HCP,Resolution*2);
    TQC=BezierCurve(TQCP,Resolution*3);

    // Display the Bézier curves.
    color(RED)
    translate([0,0,0.1])
    ShowCurve(QC,0.2);
    color(GRN)
    ShowCurve(HC,0.2);
    color(BLU)
    translate([0,0,-0.1])
    ShowCurve(TQC,0.2);
    // The true circle.
    color(MGT)
    translate([0,0,0.5])
    Arc(0,360,Radius,Animator([[0,0.001],[2,0.001],[3.5,0.8],[5,0.001],[7,0.001],[8.5,0.8],[10,0.001]]),$fn=Resolution*4);

    // Root-Mean-Square and Mean Absolute errors from true circle.

    // Cubic errors
    QAE=[for(V=QC)
        abs(Modulus(V)-Radius)
    ];
    HAE=[for(V=HC)
        abs(Modulus(V)-Radius)
    ];
    TQAE=[for(V=TQC)
        abs(Modulus(V)-Radius)
    ];
    // Mean-absolute
    QMAE=ArraySum(QAE)/len(QC);
    HMAE=ArraySum(HAE)/len(HC);
    TQMAE=ArraySum(TQAE)/len(TQC);

    Qmax=max(QAE);
    Hmax=max(HAE);
    TQmax=max(TQAE);

    // Publish data.
    Print(["\n\nQuarter maximum % error = ",Qmax/Radius*100,
           "\nHalf maximum % error = ",Hmax/Radius*100,
           "\nThree-quarter maximum % error = ",TQmax/Radius*100,

           "\n\nQuarter circle average % error = ",QMAE/Radius*100,
           "\nHalf circle average % error = ",HMAE/Radius*100,
           "\nThree-quarter circle average % error = ",TQMAE/Radius*100,

           "\n\nError ratio Half : Quarter= ",HMAE/QMAE,
           "\nError ratio 3/4 : Quarter= ",TQMAE/QMAE,"\n"]);


}




