/*
  This file belongs in

  <TheGHOUL/DemoFiles/>

  Hank J. van Leuvensteijn Jr. 2021
  theghoul@hankjr.ca
*/

include<TheGHOUL/Config.scad>

// =============================================================================

$vpr=[60,0,35];
$vpt=[0,4,12];
$vpd=110;

// Snippet to make Bézier control polygon sets:
/*
    CPS=[
        [
            [],[],[],[]
        ],
        [
            [],[],[],[]
        ]
    ];
*/

// Some colors, used below.
Color=["blue","red","green"];

// A set of Bézier curve control polygons for three (linked) curves.
CPS=[
    [   // These are cubic curves; they have 3+1 control points.
        [2,0],[5,0],[10,5],[5,10] // Notice: the end point of this...
    ],
    [
        [5,10],[5,15],[20,30],[10,25] // Is the start point of this.
    ],
    [
        [10,25],[0,20],[2,10],[2,0] // Also, the points before and after
    ]                               // the junction points are inline
];                                  // this ensures a smooth transition
                                    // as the tangents have the same slope.

Curve=BezierCurve(CPS,Resolution=50);

// Show the whole curve.
for(Point=Curve)
translate(Point)
sphere(r=0.2,$fn=3);

// Show the individual control points for each of the three Bézier curves.
for(Index=[0:len(CPS)-1])
    for(Points=CPS[Index]){
        color(Color[Index],0.5){
        translate(Points)
        sphere(r=0.5,$fn=3+Index);
        ShowCurve(CPS[Index],0.1);
}}
// Generate a polygon from the complete curve.
color([1,0.5,0],0.5)
polygon(Curve);

// Generate a rotational solid from the polygon and highlight a 'slice'.
ShowSlice(TX=0,TY=0,TZ=0,RX=0,RY=90,RZ=0,Thickness=0.01,Children=true,SliceColor="green",SliceAlpha=1.0,ChildColor="yellow",ChildAlpha=0.2)
rotate_extrude($fn=100)
polygon(Curve);
