/*
  This file belongs in

  <TheGHOUL/DemoFiles/>

  Hank J. van Leuvensteijn Jr. 2021
  theghoul@hankjr.ca
*/
/*
  Whilst developing my Bézier curve library, I made some test curves using three segments, and the shape had something of a boat in it, so I continued on that path, because, seriously, what other man-made object benefits from beautiful curvature more than a boat?

  Perhaps we should turn to Mr. John Ruskin for the answer to that question (see below).

  Here's the miracle thanks to Mr. P. Bézier, engineer and mathematician
  extraordinaire: 12 data points describe the entire hull, with only a few
  distinct parameters, for a beautiful shape that would certainly part the
  waters with grace!

  Much refinement could be made by adding a few more parameters but that's
  not the goal here, what needed to be has been achieved; a simple and
  graceful method to describe and parameterize flowing natural shapes in 3D.
*/

include<TheGHOUL/Config.scad>

function Transom( // Tangent Point Plane
        Transforms=[[0,2,0,"T"],[10,0,0,"R"]]
    )=
    [
        [
            [[ 7, 0,0],[0,90, 90],[5],[0]],
            [[ 0, 1,0],[4,90,180],[4],[0]],
            [[-7, 0,0],[5,90,270],[0],[0]],
            [[ 0,-5,0],[1,90,  0],[1],[0]]
        ],
        Transforms
    ]
;

function MidShip( // Tangent Point Plane
        Transforms=[[0,2,15,"T"]]
    )=
    [
        [
            [[ 9, 0,0],[0,90, 90],[5       ],[15],[5]],
            [[ 0, 1,0],[4,90,180],[4       ],[15],[5]],
            [[-9, 0,0],[5,90,270],[0       ],[15],[5]],
            [[ 0,-6,0],[4,90, 20],[4,90,160],[15],[5]]
        ],
        Transforms
    ]
;

function Bow( // Tangent Point Plane
        Transforms=[[0,2,40,"T"]]
    )=
    [
        [ //  Vertex       Inc  Az NV NP PV PP NVt NPt PVt PPt
            [[ 0.01,   1,0],[0,0, 90],[0],[0,70,180],[5]],
            [[    0,   1,0],[0,0,180],[0],[0, 0,  0],[0]],
            [[-0.01,   1,0],[0,0,270],[0],[0,70,  0],[5]],
            [[    0,0.99,0],[0,0,  0],[0],[0,80, 90],[5]]
        ],
        Transforms
    ]
;

Boat= // Tangent Point Plane Array
    [
        Transom(),
        MidShip(),
        Bow()
    ]
;

// Pretty TPA thingys.
rotate([0,-2,0])
rotate([90,0,90])
ShowTPA(Boat);

// Das Boot...
Waterline(0,0)color(WHT,0.7)
rotate([0,-2,0])
rotate([90,0,90])
BezierSolid(Boat);

/**
Mr. John Ruskin is certainly my favourite among the Victorians, and I dearly love his writing. Here, he stands in awe of the simple grace of a ship's bow.

THE GLORIOUS BOW.

By John Ruskin.

Of all things living or lifeless upon this strange earth, there is but one which, having reached the mid-term of appointed human endurance on it, I still regard with unmitigated amazement. I know indeed that all around me is wonderful–but I cannot answer it with wonder; a dark veil, with the foolish words, “Nature of Things” upon it casts its deadening folds between me and their dazzling strangeness. Flowers open, and stars rise, and it seems to me they could have done no less. The mystery of distant mountain-blue only makes me reflect that the earth is of necessity mountainous. The sea-wave breaks at my feet, and I do not see how it should have remained unbroken.

But one object there is still, which I never pass without the renewed wonder of childhood–and that is the bow of a boat. Not of a racing-wherry, or revenue cutter, or clipper yacht, but the blunt head of a common, bluff, undecked sea-boat, lying aside in its furrow of beach sand. The sum of Navigation is in that!

You may magnify it, or decorate it as you will; you do not add to the wonder
of it. Lengthen it into hatchet-like edge of iron, strengthen it with complex tracery of ribs of oak, carve it and gild it till a column of light moves beneath it on the sea, you have made no more of it than it was at first. That rude simplicity of bent plank that can breast its way through the death that is in the deep sea has in it the soul of shipping.

Beyond this, we may have more work, more men, more money, we cannot have more miracle. For there is, first, an infinite strangeness in the perfection of the thing as the work of human hands. I know nothing else that man does which is perfect but that. All his other doings have some sign of weakness, affectation, or ignorance in them. They are overfinished or underfinished; they do not quite answer their end, or they show a mean vanity in answering it too well.

But the boat’s bow is naïvely perfect–complete, without an effort. The man who made it knew not he was making anything beautiful as he bent its planks into those mysterious, ever-changing curves. It grows under his hand into the image of a sea-shell, the seal, as it were, of the flowing of the great tides and streams of ocean stamped on its delicate rounding. He leaves it, when all is done, without a boast. It is simple work, but it will keep out water. And every plank thenceforward is a fate, and has men’s lives wreathed in the knots of it, as the cloth-yard shaft has their deaths in its plumes.

Then, also, it is wonderful on account of the greatness of the thing accomplished. No other work of human hands ever gained so much. Steam-engines and telegraphs indeed help us to fetch, and carry, and talk. They lift weights for us, and bring messages with less trouble than would have been needed otherwise. This saving of trouble, however, does not constitute a new faculty; it only enhances powers we already possess.

But, in that bow of the boat is the gift of another world. Without it, what prison wall would be so strong as that white and wailing fingeŗ of sea? What maimed creatures were we all, chained to our rocks Andromeda-like, or wandering by the endless shores, wasting our incommunicable strength, and pining in hopeless watch of unconquerable waves! The nails that fasten together the planks of the boat’s bow are the rivets of the fellowship of the world. Their iron does more than draw lightning out of heaven, it leads love round the earth.

**/
