include<TheGHOUL/Config.scad>
$AnimSegs=10;
$Verbose=true;
$Debug=true;
//$vpt=[0,0,0];$vpr=[60,0,45];$vpd=40;

//$fa=360/19.1;

// ceil($fn/2) parallels and 1 fewer slices, ceil($fn) segments and meridians..
RR=3;
for(FN=[0:40]){
    translate([FN*2.5*RR,0,0])
    sphere(RR,$fn=FN);
    color(DSG)
    translate([FN*2.5*RR,0,0])
    rotate($vpr)
    translate([0,1.5*RR,0])
    SimpleText(str(FN),RR/3,Thickness=0.1,Center=true,Font="Noto Mono",Spacing=1);
    echo(
        FN,ceil(FN/2)-1,
        ((FN+2)%4==0||(FN+3)%4==0)?"Y":"N",
        (FN%4==0)?"Y":"N");
}

$fn=0;
$fa=12;
$fs=2;
Roc=360/$fa*$fs/2/PI;
echo("Roc= ",Roc);

*for(RR=[$fs/2:$fs/2:10*$fs]){
    translate([10*RR,0,0])
    sphere(RR);
    color(DSG)
    translate([10*RR,0,0])
    rotate($vpr)
    translate([0,1.5*RR,0])
    SimpleText(str("r= ",RR," fn= ",Fragments(RR)
    //,"-",ceil(PI*2*RR/$fs)
    ),RR/3,Thickness=0.1,Center=true,Font="Noto Mono",Spacing=1);
}

*for(RR=[$fs/2:$fs:1.2*Roc]){
    translate([15*RR,0,0])
    sphere(RR,$fn=Segments(RR));
    color(DSG)
    translate([15*RR,0,0])
    rotate($vpr)
    translate([0,1.5*RR,0])
    SimpleText(str(RR,"-",Segments(RR)),2,Thickness=0.1,Center=true,Font="Noto Mono",Spacing=1);
}

*union(){
    RR=$fs+$t*$fs*19;
    translate([20,0,0])
    sphere(RR,$fn=Fragments(RR));
    color(DSG)
    translate([15*RR,0,0])
    rotate($vpr)
    translate([0,1.5*RR,0])
    SimpleText(str(RR,"-",Segments(RR)),2,Thickness=0.1,Center=true,Font="Noto Mono",Spacing=1);
}
