/*
  This file belongs in

  <TheGHOUL/DemoFiles/>

  Hank J. van Leuvensteijn Jr. 2021
  theghoul@hankjr.ca
*/

include<TheGHOUL/Config.scad>

/*
  Nothing that happens here merits explanation. Just read the documentation and comments in the actual routines and functions that are used here if something doesn't make sense or it's not clear to you what happens here.
*/

VPT=[0,[0,0,5],[90,0,0],30];
$vpt=VPT[1];
$vpr=VPT[2];
$vpd=VPT[3];

rotate([0,30,0])
translate([0.5,0,0])
rotate([-90,-90,0])
Ruler(Divisions=[0.01,0.1,1,10]);

/* Some parameters. */
TA=atan(3/16);
THRD=TriangularThread;
OD=10;
PTC=1.5;
TRNS=5;
CF=1;
RC=undef;
LH=false;

difference(){
    rotate([0,0,180])
    color(DSG,0.8)
    Thread(
    THRD,
    OD,
    Length=undef,
    External=false,
    Turns=TRNS,
    Pitch=PTC,
    ThreadAngle=undef,
    Height=undef,
    TaperAngle=TA,
    LeftHanded=false,
    MultiStart=1,
    HigbeeIn=0,
    HigbeeOut=0,
    Higbee2D=false,
    HigbeeSkew=0,
    RootClearance=RC,
    Clearance=0,
    FlankContact=0,
    Interrupted=[60,60,15],
    ConversionFactor=CF,
    Support=false);

    translate([-100,-100-HalfCut,-1])
    color(DSG,0.7)
    cube([200,100,100]);
}

difference(){
    color(BLU,0.8)
    Thread(
    THRD,
    OD,
    Length=undef,
    External=true,
    Turns=TRNS,
    Pitch=PTC,
    ThreadAngle=undef,
    Height=undef,
    TaperAngle=TA,
    LeftHanded=LH,
    MultiStart=1,
    HigbeeIn=0,
    HigbeeOut=0,
    Higbee2D=false,
    HigbeeSkew=0,
    RootClearance=RC,
    Clearance=0,
    FlankContact=0,
    Interrupted=[60,60,15],
    ConversionFactor=CF,
    Support=false);

    translate([-100,-100-Cut,-1])
    color(BLU,0.5)
    cube([200,100,100]);
}
