/*
  This file belongs in

  <TheGHOUL/DemoFiles/>

  Hank J. van Leuvensteijn Jr. 2021
  theghoul@hankjr.ca
*/

include<TheGHOUL/Config.scad>

/* Choose an example to display. [0:10]. */
Example=7;

// Animated cutout ext/int thread with Higbee ==================================
//$vpt=[0,0,4]; // Center view
if(Example==0)
{
    $t=0.42; // Troubleshooting
    cut=true;
    T1=0;
    T=StringTee(0,5,0,-5)+StringTee(5,10,0,5);
    translate([0,0,T*1.5])
    rotate([0,0,T*360])
    difference(){
        color(GPG)
        rotate([0,0,0])
        Thread(TriangularThread,10,10,External=true,Turns=undef,Pitch=1.5,Lead=undef,ThreadAngle=undef,Height=undef,TaperAngle=T1,LeftHanded=false,MultiStart=1,HigbeeIn=30,HigbeeOut=0,Higbee2D=false,RootClearance=undef,Clearance=0.005,FlankContact=0,Interrupted=[120,40,20],ConversionFactor=1,Support=true);
        if(cut)
        color(MNB)
        translate([-ViewCut,-30+ViewCut,-Cut])
        cube([30,30,30]);
    }
    difference(){
        color(OSG)
        translate([-7.5,-7.5,Smidge])
        cube([15,15,12.5]);
        color(OSG)
        rotate([0,0,180])
        Thread(TriangularThread,10,10,External=false,Turns=undef,Pitch=1.5,Lead=undef,ThreadAngle=undef,Height=undef,TaperAngle=T1,LeftHanded=false,MultiStart=1,HigbeeIn=30,HigbeeOut=30,Higbee2D=true,RootClearance=undef,Clearance=Tad,FlankContact=0,Interrupted=[0,0,0],ConversionFactor=1,Support=true);
        if(cut)
        color(RED)
        translate([0,-30,-Cut])
        cube([30,30,30]);
    }
}


// Higbee demo
//$vpt=[0,7,-4];$vpr=[90,0,90]; // Center view
if(Example==1)
{
    R1=[0,10,30];
    // Higbee demo
    rotate(R1)
    Thread(TriangularThread,10,Length=undef,External=true,Turns=1,Pitch=2,Lead=undef,ThreadAngle=undef,Height=undef,TaperAngle=0,LeftHanded=false,MultiStart=1,HigbeeIn=0,HigbeeOut=0,Higbee2D=false,HigbeeSkew=0.7,RootClearance=undef,Clearance=0,FlankContact=0,Interrupted=[0,0,0],ConversionFactor=1,Support=true);
    color(DSG)
    translate([0,0,-3])
    rotate([70,0,70])
    SimpleText("No Higbee",1,Thickness=0.3,Center=true,Font="Noto Mono",Spacing=1);

    translate([0,15,0])
    rotate(R1)
    Thread(TriangularThread,10,Length=undef,External=true,Turns=1,Pitch=2,Lead=undef,ThreadAngle=undef,Height=undef,TaperAngle=0,LeftHanded=false,MultiStart=1,HigbeeIn=60,HigbeeOut=0,Higbee2D=false,HigbeeSkew=0,RootClearance=undef,Clearance=0,FlankContact=0,Interrupted=[0,0,0],ConversionFactor=1,Support=true);
    color(DSG)
    translate([0,15,-3])
    rotate([70,0,70])
    SimpleText("Higbee",1,Thickness=0.3,Center=true,Font="Noto Mono",Spacing=1);

    translate([0,0,-10])
    rotate(R1)
    Thread(TriangularThread,10,Length=undef,External=true,Turns=1,Pitch=2,Lead=undef,ThreadAngle=undef,Height=undef,TaperAngle=0,LeftHanded=false,MultiStart=1,HigbeeIn=60,HigbeeOut=0,Higbee2D=true,HigbeeSkew=0,RootClearance=undef,Clearance=0,FlankContact=0,Interrupted=[0,0,0],ConversionFactor=1,Support=true);
    color(DSG)
    translate([0,0,-13])
    rotate([70,0,70])
    SimpleText("2D Higbee",1,Thickness=0.3,Center=true,Font="Noto Mono",Spacing=1);

    translate([0,15,-10])
    rotate(R1)
    Thread(TriangularThread,10,Length=undef,External=true,Turns=1,Pitch=2,Lead=undef,ThreadAngle=undef,Height=undef,TaperAngle=0,LeftHanded=false,MultiStart=1,HigbeeIn=60,HigbeeOut=0,Higbee2D=true,HigbeeSkew=0.8,RootClearance=undef,Clearance=0,FlankContact=0,Interrupted=[0,0,0],ConversionFactor=1,Support=true);
    color(DSG)
    translate([0,15,-13])
    rotate([70,0,70])
    SimpleText("2D Higbee",1,Thickness=0.3,Center=true,Font="Noto Mono",Spacing=1);
    color(DSG)
    translate([0,15,-15])
    rotate([70,0,70])
    SimpleText("with Skew",1,Thickness=0.3,Center=true,Font="Noto Mono",Spacing=1);

}

// multi-start external thread with additional parameters used
//$vpt=[0,0,0];$vpr=[45,0,45]; // Center view
if(Example==2)
{
    A2=min(1,$t*2);
    T2=15;
    // normal Call with some additional parameters used
    color(DGN)
    Thread(TriangularThread, // see Profiles.scad for a List of available profiles and how to use them
    10, // nominal diameter
    Length=undef, // undef if 'Turns' is specified
    External=false, // internal thread
    Turns=1, // turns
    Pitch=1.5, // Pitch is provided by the lookup table, it can only be specified for non-standard threads
    Lead=undef,
    ThreadAngle=undef, // Thread-profile angle (60 for most threads) only for non-standard threads
    Height=undef, // Thread-profile height, only for non-standard threads
    TaperAngle=T2, // taper angle (certain gas-threads and quick connect threads have this)
    LeftHanded=false, // true = left-handed thread
    MultiStart=3,  // multi-start is more than one thread-helix
    HigbeeIn=0, // Higbee-in / -out, degrees
    HigbeeOut=0,
    Higbee2D=false,
    HigbeeSkew=0,
    RootClearance=undef, // root clearance override
    Clearance=0, // additional clearance on the thread surface; negative value = less material = more clearance
    FlankContact=0, // rotates finished thread to preserve contact when additional clearance is specified, allows you to see how the mating parts will be positioned when 'tight'
    Interrupted=[0,0,0], // interrupted thread, like on a soda bottle
    ConversionFactor=1, // for using metric thread in imperial designs and v.v.
    Support=false); // thread support surface, i.e. bolt-shank &c.
}

// NPT
//$vpt=[0,0,0];$vpr=[60,0,45]; // Center view
if(Example==3)
{
    difference(){
        union(){
        Thread(NPTThread,1,Length=undef,External=true,Turns=10,Pitch=undef,Lead=undef,ThreadAngle=undef,Height=undef,TaperAngle=0,LeftHanded=false,MultiStart=1,HigbeeIn=30,HigbeeOut=0,Higbee2D=false,HigbeeSkew=0,RootClearance=undef,Clearance=0,FlankContact=0,Interrupted=[0,0,0],ConversionFactor=24.5,Support=true);
        translate([0,0,0.5])
        cylinder(r1=1.315*24.5/2,r2=14.6814,h=2);
        translate([0,0,-29.5])
        cylinder(r=1.315*24.5/2,h=30,center=false);}

        color(OSG)
        cylinder(r=12,h=60,center=true);
    }

    ScreenText(Text="1\" NPT",Location=[-0.7,-4,9],Rotation=[1,1,0],Size=2,_SizeCompensation=40);

}

// debug setup-ish
//$vpt=[0,0,3];$vpr=[90,0,0]; // Center view
if(Example==4)
{

    T4=30*sin((2*180*$t)%180);
    OD4=6;
    P4=1.5;
    S4=0;

    color(BLU)
    difference(){
        rotate([0,0,360*S4])
        translate([0,0,S4*P4])
        Thread(TriangularThread,OD4,Length=undef,External=true,Turns=3,Pitch=P4,Lead=undef,ThreadAngle=undef,Height=undef,TaperAngle=T4,LeftHanded=false,MultiStart=1,HigbeeIn=0,HigbeeOut=0,Higbee2D=false,HigbeeSkew=0,RootClearance=undef,Clearance=0.005,FlankContact=0,Interrupted=[0,0,0],ConversionFactor=1,Support=true);
        translate([0,-10-Tad,0])
        cube([20,20,20],center=true);
        translate([0,10+Tad,0])
        cube([20,20,20],center=true);
    }
    color(RED)
    difference(){
        rotate([0,0,180])
        Thread(TriangularThread,OD4,Length=undef,External=false,Turns=3,Pitch=P4,Lead=undef,ThreadAngle=undef,Height=undef,TaperAngle=T4,LeftHanded=false,MultiStart=1,HigbeeIn=0,HigbeeOut=0,Higbee2D=false,HigbeeSkew=0,RootClearance=undef,Clearance=0,FlankContact=0,Interrupted=[0,0,0],ConversionFactor=1,Support=false);
        translate([0,-10-Smidge,0])
        cube([20,20,20],center=true);
        translate([0,10+Smidge,0])
        cube([20,20,20],center=true);
    }
}


// breech/bolt-like Interrupted threads
// uncomment the next lines for and open View-Animate
/*
    View=ViewPort([
        [0,[0,0,0],[60,0,-40],100],
        [1,[0,0,0],[0,0,0],100],
        [4,[0,0,0],[0,0,0],100],
        [5,[0,0,0],[90,0,0],100],
        [7,[0,0,0],[90,0,0],100],
        [10,[0,0,0],[60,0,-40],100]
    ]);
    $vpt=View[1];$vpr=View[2];$vpd=View[3];
*/
if(Example==5)
{
// Interrupted threads, this could make a quick-connect. Unless you're into guns ;-)

    color(BLU)
    translate([0,0,StringTee(0.5,1,-20,0)])
    translate([0,0,StringTee(1,4,0,1)])
    translate([0,0,StringTee(4,6,0,-1)])
    rotate([0, 0, 179+StringTee(1,4,0,60)])
    rotate([0, 0, StringTee(4,6,0,-60)])
    translate([0,0,StringTee(6,8,0,-20)])

    Thread(SquareThread,20,Length=undef,External=true,Turns=2,Pitch=6,Lead=undef,ThreadAngle=undef,Height=3,TaperAngle=0,LeftHanded=false,MultiStart=1,HigbeeIn=0,HigbeeOut=0,Higbee2D=false,HigbeeSkew=0,RootClearance=-0.0,Clearance=-0.02,FlankContact=0,Interrupted=[60,60,15],ConversionFactor=1,Support=true);

    color(RED,StringTee(1,4,1,0.3)+StringTee(4,6,0,0.7))
    difference(){
        difference(){
            translate([0,0,0.1])
            cylinder(r=15,h=17);
            Thread(SquareThread,20,Length=undef,External=false,Turns=2,Pitch=6,Lead=undef,ThreadAngle=undef,Height=3,TaperAngle=0,LeftHanded=false,MultiStart=1,HigbeeIn=0,HigbeeOut=0,Higbee2D=false,HigbeeSkew=0,RootClearance=-0.0,Clearance=-0.02,FlankContact=0,Interrupted=[58,62,15],ConversionFactor=1,Support=true);
        }
        translate([16,-16,-HalfCut])
        translate([StringTee(0,1,0,-32),0,0])
        translate([StringTee(9,9.99,0,-64),0,0])
        cube([32,16,25]);
    }
}

// PCO 1881-like threads (like a carbonated drink bottle closure)
//$vpt=[0,0,0];$vpr=[0,0,0];$vpd=60; // Center view
if(Example==6)
{
    $fn=72;
    R6=10; // Nominal radius
    T6=3; // Turns
    P6=3; // Pitch
    I6=[80,30,15,30]; // Interrupted threads, Higbee

        // Interrupted threads, a bit like PCO 1881
    rotate([0,360*$t,0])
    rotate([0,0,360*$t])
    translate([0,0,-T6*P6/2])
    union(){

        color(RED)
        rotate([0, 0, 180])
        Thread(TriangularThread,R6*2,Length=undef,External=true,Turns=T6,Pitch=P6,Lead=undef,ThreadAngle=undef,Height=undef,TaperAngle=0,LeftHanded=false,MultiStart=1,HigbeeIn=I6[3],HigbeeOut=I6[3],Higbee2D=false,HigbeeSkew=0,RootClearance=undef,Clearance=Smidge,FlankContact=0,Interrupted=I6,ConversionFactor=1,Support=false);

        difference(){
            color(BLU,0.5)
            Thread(TriangularThread,R6*2,Length=undef,External=false,Turns=T6,Pitch=P6,Lead=undef,ThreadAngle=undef,Height=undef,TaperAngle=0,LeftHanded=false,MultiStart=1,HigbeeIn=I6[3],HigbeeOut=I6[3],Higbee2D=false,HigbeeSkew=0,RootClearance=undef,Clearance=0,FlankContact=0,Interrupted=[0,0,0],ConversionFactor=1,Support=false);
            color(BLU,0.7)
            rotate([0,0,45])
            translate([-R6-0.5,0,-HalfCut])
            cube([2*R6+1,R6+1,(T6+1)*P6+Cut]);
        }
    }
}

// /* Pretty interrupted food closure threads. */
//$vpt=[10,10,0];$vpr=[60,0,-45];$vpd=260; // Center view
if(Example==7)
{
    // normal Call with some additional parameters used
    color(DGN)
    Thread(TriangularThread, // see Profiles.scad for a List of available profiles and how to use them
    90, // nominal diameter
    Length=undef, // undef if 'Turns' is specified
    External=true, // internal thread
    Turns=0.5, // turns
    Pitch=5, // Pitch is provided by the lookup table, it can only be specified for non-standard threads
    Lead=undef,
    ThreadAngle=undef, // Thread-profile angle (60 for most threads) only for non-standard threads
    Height=undef, // Thread-profile height, only for non-standard threads
    TaperAngle=0, // taper angle (certain gas-threads and quick connect threads have this)
    LeftHanded=false, // true = left-handed thread
    MultiStart=4,  // multi-start is more than one thread-helix
    HigbeeIn=30, // Higbee-in / -out, degrees
    HigbeeOut=30,
    Higbee2D=false,
    HigbeeSkew=0,
    RootClearance=undef, // root clearance override
    Clearance=0, // additional clearance on the thread surface; negative value = less material = more clearance
    FlankContact=0, // rotates finished thread to preserve contact when additional clearance is specified, allows you to see how the mating parts will be positioned when 'tight'
    Interrupted=[30,70,30], // interrupted thread, like on a soda bottle
    ConversionFactor=1, // for using metric thread in imperial designs and v.v.
    Support=true, // thread support surface, i.e. bolt-shank &c.
    $Verbose=true);
}

// square thread /* Needs prettyfication? */
//$vpt=[-7,7,0];$vpr=[70,0,45];$vpd=50; // Center view
if(Example==8)
{
    // square threads
    T=StringTee(0,5,0,-2)+StringTee(5,10,0,2);
    translate([0,0,T*3])
    rotate([0,0,T*360])
    difference(){
        color(GRN)
        rotate([0,0,180])
        Thread(SquareThread,10,Length=undef,External=false,Turns=2.5,Pitch=3,Lead=undef,ThreadAngle=undef,Height=1,TaperAngle=0,LeftHanded=false,MultiStart=1,HigbeeIn=0,HigbeeOut=0,Higbee2D=false,HigbeeSkew=0,RootClearance=0,Clearance=0,FlankContact=0,Interrupted=[0,0,0],ConversionFactor=1,Support=false);
        translate([-HalfCut,-12+HalfCut,-HalfCut])
        color(BLU)
        cube([12, 12, 12]);
    }

    difference(){
        Thread(SquareThread,10,Length=undef,External=true,Turns=2.5,Pitch=3,Lead=undef,ThreadAngle=undef,Height=1,TaperAngle=0,LeftHanded=false,MultiStart=1,HigbeeIn=0,HigbeeOut=0,Higbee2D=false,HigbeeSkew=0,RootClearance=0,Clearance=0.05,FlankContact=0,Interrupted=[0,0,0],ConversionFactor=1,Support=true);
        translate([0,-12,-HalfCut])
        color(RED)
        cube([12, 12, 12]);
    }
}

// garden hose
//$vpt=[0,0,6];$vpr=[60,0,120];$vpd=80; // Center view
if(Example==9)
{
        SectorCut(-45,90,20,40,Color=DBL)
        color(BLU)
        Thread(GardenHoseThread,undef,Length=undef,External=true,Turns=4.25,Pitch=undef,Lead=undef,ThreadAngle=undef,Height=undef,TaperAngle=0,LeftHanded=false,MultiStart=1,HigbeeIn=30,HigbeeOut=30,Higbee2D=false,HigbeeSkew=0,RootClearance=undef,Clearance=Thought,FlankContact=0,Interrupted=[0,0,0],ConversionFactor=25.4,Support=false);

        SectorCut(0,90,20,40,Color=DRD)
        color(RED)
        rotate([0, 0, 180])
        Thread(GardenHoseThread,undef,Length=undef,External=false,Turns=4.25,Pitch=undef,Lead=undef,ThreadAngle=undef,Height=undef,TaperAngle=0,LeftHanded=false,MultiStart=1,HigbeeIn=30,HigbeeOut=30,Higbee2D=false,HigbeeSkew=0,RootClearance=undef,Clearance=0,FlankContact=0,Interrupted=[0,0,0],ConversionFactor=25.4,Support=false);
}

// knuckle thread
//$vpt=[-7,7,0];$vpr=[70,0,45];$vpd=50; // Center view
if(Example==10)
{
    // knuckle threads

    difference(){
        color(GRN)
        rotate([0,0,180])
        Thread(KnuckleThread,10,Length=undef,External=false,Turns=2.5,Pitch=3,Lead=undef,ThreadAngle=undef,Height=1,TaperAngle=0,LeftHanded=false,MultiStart=1,HigbeeIn=0,HigbeeOut=0,Higbee2D=false,HigbeeSkew=0,RootClearance=0,Clearance=0,FlankContact=0,Interrupted=[0,0,0],ConversionFactor=1,Support=false);
        translate([-HalfCut,-12+HalfCut,-HalfCut])
        color(BLU)
        cube([12, 12, 12]);
    }

    *difference(){
        color(OSG)
        Thread(KnuckleThread,10,Length=undef,External=true,Turns=2.5,Pitch=3,Lead=undef,ThreadAngle=undef,Height=1,TaperAngle=0,LeftHanded=false,MultiStart=1,HigbeeIn=0,HigbeeOut=0,Higbee2D=false,HigbeeSkew=0,RootClearance=0,Clearance=0.05,FlankContact=0,Interrupted=[0,0,0],ConversionFactor=1,Support=true);
        translate([0,-12,-HalfCut])
        color(RED)
        cube([12, 12, 12]);
    }
}

