/*
  This file belongs in

  <TheGHOUL/DemoFiles/>

  Hank J. van Leuvensteijn Jr. 2021
  theghoul@hankjr.ca
*/

include<TheGHOUL/Config.scad>

/*
  Nothing that happens here merits explanation. Just read the documentation and comments in the actual routines and functions that are used here if something doesn't make sense or it's not clear to you what happens here.
*/

// A pulley.
color(DSG)
translate([0,0,-1])
GTPulley(30);

// A single tooth
translate([0,0,2])
color("red")
GTTooth(30);

// Belt section used as cutting body, like in a belt tensioner.
GTth=30;
GTPt=BeltData("GT3-2")[0];
GTPr=GTPCD(GTth)/2;

// Semicircle
color(CPR)
translate([0,25,0])
difference(){
    translate([0,10,-3])
    cube([30,20,10],center=true);

    linear_extrude(height=8,center=true,convexity=10)
    for(Index=[0:15])
    rotate([0,0,Index*360/GTth])
    // Notice added clearance.
    GTTooth(Teeth=GTth,Clearance=0.5);
}

// Straight sections
color(CPR)
translate([0,25,0])
difference(){
    translate([0,-2.5,-3])
    cube([30,5,10],center=true);

    linear_extrude(height=8,center=true,convexity=10)
    for(Index=[0:5])
    translate([GTPr,-Index*GTPt,0])
    // Notice added clearance.
    GTTooth(Teeth=0,Clearance=0.5);

    mirror([-1,0,0])
    linear_extrude(height=8,center=true,convexity=10)
    for(Index=[0:5])
    translate([GTPr,-Index*GTPt,0])
    // Notice added clearance.
    GTTooth(Teeth=0,Clearance=0.5);
}

// EOF =========================================================================
