/*
  This file belongs in

  <TheGHOUL/DemoFiles/>

  Hank J. van Leuvensteijn Jr. 2021
  theghoul@hankjr.ca
*/

include<TheGHOUL/Config.scad>

// =============================================================================

// Define a cube.
PrePoints=[
            [0,0,0],[5,0,0],[5,5,0],[0,5,0],
            [0,0,5],[5,0,5],[5,5,5],[0,5,5],
        ];
Faces=[[0,1,2,3],[0,1,5,4],[1,2,6,5],[2,3,7,6],[3,0,4,7],[4,5,6,7]];

// Define a transformation matrix, see 'Matrix.scad' library.
TMatrix=ShearingMatrix([[1,0,0],[0,1,0.5],[0,0,1],"SH"]);
PostPoints=AffineTransform(TMatrix,PrePoints);
PostPostPoints=AffineTransform(ScalingMatrix([1,1,2]),PostPoints);

color("green")
polyhedron(
    convexity=4,
    points=PostPoints,
    faces=Faces
);
color("yellow",0.5)
polyhedron(
    convexity=4,
    points=PostPostPoints,
    faces=Faces
);
color("red",0.5)
polyhedron(
    convexity=4,
    points=PrePoints,
    faces=Faces
);
