/*
  This file belongs in

  <TheGHOUL/DemoFiles/>

  Hank J. van Leuvensteijn Jr. 2021
  theghoul@hankjr.ca
*/

include<TheGHOUL/Config.scad>

// =============================================================================


PrePoints=[
            [0,0,0],[5,0,0],[0,5,0],
            [1,1,3],[4-sqrt(2),1,3],[1,4-sqrt(2),3]
        ];
Faces=[[0,1,2],[0,3,4,1],[1,4,5,2],[2,5,3,0],[3,5,4]];

/* Un-comment only ONE 'TMatrix=' statement. */

// This ========================================================================
    Transforms=[[0,0,45,"R"],[0,10,0,"T"],[1,1,2,"S"]];
    TMatrix=TransformMatrix(Transforms);

// Is the same as ==============================================================
//    TMatrix=ScalingMatrix([1,1,2])*TranslationMatrix([0,10,0])*RotationMatrix([0,0,45]);

// Something else ==============================================================
//    TMatrix=RotationMatrix(UnitVector([1,1,sqrt(2)]),180);


PostPoints=AffineTransform(TMatrix,PrePoints);

// The 'after'
color("red")
polyhedron(
    convexity=4,
    points=PostPoints,
    faces=Faces
);

// The 'before'
color("yellow",0.3)
polyhedron(
    convexity=4,
    points=PrePoints,
    faces=Faces
);
