/*
  I used this code to troubleshoot The GHOUL's routines. It may come in handy for you, to play around with, or to gain a better understanding of gears or The GHOUL's routines...

  It's not very well commented, because, well, it's just here as a 'bonus'; perhaps when I feel bored one day, I'll do something about it...
*/

/* You gotta get The GHOUL. */
include<TheGHOUL/Config.scad>

$t=0.75;  // Comment out for animation view.

ROT=2*$t-0.5;//*4-1-0.49; // RollFactor.
PA=20; // Pressure angle.
M=2; // Module.
LT=0.01*M; // Line thickness of curves &c.

Z1=22;
Z2=80;

AD1=1.0;
DD1=1.25;
R1=0.4;
T1=0;
RO1=1;
PS1=0;
PCR1=M*Z1/2;
BCR1=PCR1*cos(PA);
ACR1=PCR1+M*(AD1+PS1);
DCR1=PCR1-M*(DD1-PS1);
P=Pi*M;
PAng=360/Z1;

AD2=1.0;
DD2=1.25;
R2=R1;
T2=T1;
RO2=1/RO1;
PS2=-PS1;
PCR2=M*Z2/2;
BCR2=PCR2*cos(PA);
ACR2=PCR2+M*(AD2+PS2);
DCR2=PCR2-M*(DD2-PS2);

CD=M*(Z1+Z2)/2+PS1+PS2;

// First point of contact, X-coordinate, where the mating gear's tip-circle (OD) intersects the line of action.
ContactPoint=(-2*PCR2+sqrt(Pow2(2*PCR2)-4*(Pow2(tan(90-PA))+1)*(Pow2(PCR2)-Pow2(ACR2))))/(2*(Pow2(tan(90-PA))+1));
Print(["ContactPoint ",ContactPoint]);
translate([0,0,-0.1])
VLine(-ContactPoint,Thickness=0.02);

// Rack first contact at crossing of line of contact. This is at radius:
RFCR=sqrt(Pow2(M*DD1/tan(PA))+Pow2(DCR1));
Print(["Root ",DCR1,"Base ",BCR1,"Rack ",RFCR,"Pitch ",PCR1],true,0);

// Focus point for animations.
PNT=AffineRotate([0,0,(ROT-0.5)*PAng],[PCR1,0,0])+[-PCR1,0,0];
$vpt=PNT;


/* Max gear OD without interference. */
//MXOR=Sqrt(Pow2(CD)+Pow2(BCR1)-2*CD*BCR1*cos(PA));
/*
  Max gear OD. By definition the max no-interference gear OD intersects the pinion base circle where a pinion radial is at the pressure angle to the line connecting the centers. Therefore we know the triangle side that is normal to the center connector equals BCR*sin(PA). The other triangle side equals the center distance minus BCR*cos(PA).
*/
MXOR=Sqrt(Pow2(BCR1*sin(PA))+Pow2(M*(Z1+Z2)/2-BCR1*cos(PA)));
INT=(ACR2-MXOR)/M;
/* Gear tooth interference (Gear OD crosses Pinion Base circle _outside_ of LOC). */
Print(["Gear interference at ",MXOR," OR."]);
Print(["Current Gear OR is ",ACR2,"."]);
Print(["Profile Shift required is ",INT,"."]);
/* Min teeth to avoid rack interference / natural undercut. */
MNZ=2*(AD1)*(1+1/Pow2(tan(PA)));
Print(["Rack interference below ",MNZ," teeth."]);

/* Base pitch. */
BP1=BCR1*Tau/Z1;
/* Line of contact. */
LA=Sqrt(Pow2(ACR1)-Pow2(BCR1))+Sqrt(Pow2(ACR2)-Pow2(BCR2))-Sqrt(Pow2(CD)-Pow2(BCR1+BCR2));
/* Contact ratio. */
CR=LA/BP1;
Print(["Contact Ratio is ",CR,"."]);
Print(["Full Involute at ",2*AD1/(1-cos(PA))," teeth."]);

/* Trochoid/radius cut-off (Base circle smaller than dedendum circle/meshing tip circle). */
//ScreenText(Text=str(2*(AD1-PS1)/(1-cos(PA))),Location=[2,-4,0],Rotation=[0,0,0],Size=1,Color=DSG,_SizeCompensation=40);
/* Profile shift required due to gear tooth interference. */
//ScreenText(Text=str(INT),Location=[2,-4,0],Rotation=[0,0,0],Size=1,Color=DSG,_SizeCompensation=40);


/* Shift angle (not used). */
PSAng=Deg(PS1*M*tan(PA)/PCR1);

// Some circles.
translate([-PCR1,0,0]){
    $fn=100;
    color(RED)
    Circle(ACR1,LT*2); // Tip
    color(GRN)
    Circle(BCR1,LT*2); // Base
    color(BLU)
    Circle(PCR1,LT*2); // Pitch
    color(DSG)
    Circle(DCR1,LT*2); // Root
}
translate([PCR2,0,0]){
    $fn=100;
    color(RED)
    Circle(ACR2,LT*2,$fn=2880); // Tip
    color(GRN)
    Circle(BCR2,LT*2); // Base
    color(BLU)
    Circle(PCR2,LT*2); // Pitch
    color(DSG)
    Circle(DCR2,LT*2); // Root
}

translate([0,0,0]){
    /* Line of action. */
    CylinderBetween(
        BCR1*[cos(PA),-sin(PA)]+[-PCR1,0],
        BCR2*[-cos(PA),sin(PA)]+[PCR2,0],
        Radius=LT,$fn=$fc
    );
    /* Extended LOA. */
    *ALine(90-PA,Thickness=LT*2);

    /* Gear1 radius. */
    CylinderBetween(
        [-PCR1,0],
        BCR1*[cos(PA),-sin(PA)]+[-PCR1,0],
        Radius=LT,$fn=$fc
    );
    /* Gear2 radius. */
    CylinderBetween(
        [PCR2,0],
        BCR2*[-cos(PA),sin(PA)]+[PCR2,0],
        Radius=LT,$fn=$fc
    );
}


/* Pinion tooth. */
color(GRN)
translate([-PCR1,0,-0.5])
rotate([0,0,(ROT-1)*PAng])
    polygon(CropArray(InvoluteGearTooth(M,Z1,AD1,DD1,PS1,PA,0,"")));

/* Gear tooth. */
color(BLU)
translate([PCR2,0,-0.5])
rotate([0,0,180+PAng*Z1/Z2/2-ROT*PAng*Z1/Z2])
    polygon(CropArray(InvoluteGearTooth(M,Z2,AD2,DD2,PS2,PA,0,"")));

/* Cutting rack with DD for both AD and DD so it's a cutter 'both sides'. */
color(RED,0.5)
    translate([0,ROT*P+P/2,-LT-0.5])
    rotate([0,0,180])
        Rack(M,Z1,DD2,DD1,PS2,PA,0,"",0,0,M*3);

/* Working rack. */
*color(RED,0.5)
    translate([0,ROT*P+P/2,-LT-0.5])
    rotate([0,0,180])
        Rack(M,Z1,AD2,DD2,PS2,PA,0,"",0.2,0.2,M*3);
