/*
  This file belongs in

  <TheGHOUL/DemoFiles/>

  Hank J. van Leuvensteijn Jr. 2021
  theghoul@hankjr.ca
*/

include<TheGHOUL/Config.scad>

/* Set the graph/function domain. */
Domain=2;
$AnimSegs=3;
AnimVector=[0.5,1,2,2.5];
RSphere=0.02;

// Pick a good viewpoint.
$vpr=[0,0,0];
//$vpt=[0.5*$AnimSegs,0.5,0];
$vpt=[1.1,-0.5,0];
$vpd=3*$AnimSegs;

// Generate some graph paper...
translate([0,0,-0.01])
GraphPaper(Major=1,Minor=0.1,Size=[[-0.1,-0.1],[$AnimSegs+0.1,1.1]],LineFactor=262,Color=[0.5,0.5,0.5],Alpha=0.3);

/*
  Experiment with the parameters directly in this call. See the actual function AnimationFxTwoSines() for an explanation of the parameters. This is just a demo-file.

  Activate ONE of the module calls immediately below, or more if you'd like to compare...
*/

*TS(AnimVector,Base=0.1,SinA=[0.6,90,2],SinB=[0.6,180,12],Freq=1,Max=2); // TwoSines

*TC(AnimVector,Base=0,CosA=[0.5,90,1],CosB=[0.4,360,1],Freq=1,Max=1); // TwoCosines

*TRNGL(Freq=2); // Triangle

FRAC(Freq=1); // Fraction

*SQR(Freq=2); // Square

*BMP(); // Bump

*BNC(); // Bounce

*LPH(); // Alpha

*OMG(); // Omega

*FLS(); // Flash

*DIP(); // Dip

*WBL(); // Wobble

*AMR(); // Animator
/*
  The modules that draw the above graphs. They all have uppercase names, so we know for sure there's no conflict with library modules and functions.
*/

module TS(AnimVector,Base,SinA,SinB,Freq,Max){
    for(I=[0:0.001:$AnimSegs])
    translate([I,AnFxTS(AnimVector,Base,SinA,SinB,Freq,Max,$t=I/$AnimSegs),0])
    sphere(r=RSphere,$fn=10);
}

module TC(AnimVector,Base,CosA,CosB,Freq,Max){
    for(I=[0:0.001:$AnimSegs])
    translate([I,AnFxTC(AnimVector,Base,CosA,CosB,Freq,Max,$t=I/$AnimSegs),0])
    sphere(r=RSphere,$fn=10);
}

module TRNGL(Freq=1){
    for(I=[0:0.01:$AnimSegs])
    translate([I,AnFxTr(AnimVector,Freq,$t=I/$AnimSegs),0])
    sphere(r=RSphere,$fn=10);
}

module FRAC(Freq=1){
    for(I=[0:0.01:$AnimSegs])
    translate([I,AnFxFr(AnimVector,Freq,$t=I/$AnimSegs),0])
    sphere(r=RSphere,$fn=10);
}

module SQR(Freq=1){
    for(I=[0:0.01:$AnimSegs])
    translate([I,AnFxSq(AnimVector,Freq,$t=I/$AnimSegs),0])
    sphere(r=RSphere,$fn=10);
}

module BMP(){
    for(I=[0:0.01:$AnimSegs])
    translate([I,AnFxTS(AnimVector,0,[1,90,6],[0.8,180,6],$t=I/$AnimSegs),0])
    sphere(r=RSphere,$fn=10);
}

module BNC(){
    for(I=[0:0.01:$AnimSegs])
    translate([I,AnFxTS(AnimVector,0,[1,90,6],[1.2,180,6],$t=I/$AnimSegs),0])
    sphere(r=RSphere,$fn=10);
}

module LPH(){
    for(I=[0:0.01:$AnimSegs])
    translate([I,AnFxTS(AnimVector,0.3,[0.7,90,2],[0,180,1],$t=I/$AnimSegs),0])
    sphere(r=RSphere,$fn=10);
}

module OMG(){
    for(I=[0:0.01:$AnimSegs])
    translate([I,AnFxTS(AnimVector,1,[-0.7,90,2],[0,180,1],$t=I/$AnimSegs),0])
    sphere(r=RSphere,$fn=10);
}

module FLS(){
    for(I=[0:0.01:$AnimSegs])
    translate([I,AnFxTS(AnimVector,0,[0,90,1],[1,180,2],$t=I/$AnimSegs),0])
    sphere(r=RSphere,$fn=10);
}

module DIP(){
    for(I=[0:0.01:$AnimSegs])
    translate([I,AnFxTS(AnimVector,1,[0,90,1],[-1,180,2],$t=I/$AnimSegs),0])
    sphere(r=RSphere,$fn=10);
}

module WBL(){
    for(I=[0:0.01:$AnimSegs])
    translate([I,AnFxTS(AnimVector,0.5,[0,90,1],[-0.5,360,1],$t=I/$AnimSegs),0])
    sphere(r=RSphere,$fn=10);
}

module AMR(){
    for(I=[0:0.01:$AnimSegs])
    translate([I,Animator([[0,0.9],[1.5,0.7,0.5],[2.5,0.9],[4,0.4],[5,0.4]],$t=I/$AnimSegs),0])
    sphere(r=RSphere,$fn=10);
}
