/*
  This file belongs in

  <TheGHOUL/DemoFiles/>

  Hank J. van Leuvensteijn Jr. 2021
  theghoul@hankjr.ca
*/

include<TheGHOUL/Config.scad>

// Changes size but because $vpt and $vpd are compensated, 'nothing changes'
Size=1;

$vpt=[13.72,8,2.65]*Size;
$vpr=[45,0,340];
$vpd=80*Size;

// Not much to say here...
for(I=[0:2])
for(J=[0:2])
for(K=[0:2])
// Give some proportion
translate([I*10,J*7.5,K*2.5]*Size)
// Normalise for color
color([I,J,K]/2)
// Generate text
linear_extrude(0.3*Size)
text(str("[",I,"][",J,"][",K,"]"),size=Size,font="Noto Mono");
