/*
  This file belongs in

  <TheGHOUL/DemoFiles/>

  Hank J. van Leuvensteijn Jr. 2021
  theghoul@hankjr.ca
*/

include<TheGHOUL/Config.scad>

/* OPEN THE ANIMATION VIEW WITH STEPS=100 AND FPS=10. */

/*
  This here file has some pretty nifty stuff in it that may not be completely
  clear if you don't have a look at the 'Animation.scad' library first...
*/
$fn=36;
$vpr=[30,0,60];
$vpt=[-10,20,0];
$vpd=180;

/*
  Required; number of animation segments, equal to seconds ONLY IF you
  make SURE that in the OpenSCAD Animation View, Steps=FPS*$AnimSegs, otherwise to be interpreted as 'animation segments'.
*/
$AnimSegs=10; // already set in Config,scad

/*
  Pick a set for the routines below to use, no need to mess with anything
  else. Okay, you'll do it anyway. Make a backup copy first...

  By using a function here, it's possible to 'reference' a variable "before"
  it's been declared ;-)
*/
function CPS()=CPS4;

/*
  The first call just shows the generation of one point.
  The second call needs the animation view in OpenSCAD.
*/
*ShowDeCasteljau(CPS(),0.9);
ShowDeCasteljau(CPS(),AnimationFxFraction([2,2,7,]));

// Some colors.
Color=["blue","red","green"];

// A few Bézier curve control point sets to work with.
CPS1=[
    [
        [0,0],[5.52,0],[10,4.48],[10,10]
    ]
];

/*
  Flat center section... There's a better way.
*/
CPS2=[
    [
        [0,0],[15,5],[5,15],[15,25],[5,35],[15,45],[0,50]
    ]
];
/* A better way. */
CPS2A=[
    [
        [0,0],[10,5],[10,15],[10,25]
    ],
    [
        [10,25],[10,35],[10,45],[0,50]
    ]
];

/*
  Extreme values to achieve desired curvature, could be easier done with a
  multi-segment curve.
*/
CPS3=[
    [
        [0,0],[10,5],[10,10],[12,15],[0,20],[10,35],[0,35]
    ]
];

/*
  A two segment curve has more control, you can have as many segments as you
  like. The end/start (joint) points must of course be the same and to have
  smooth transitions, the joint points and the points before and after the
  joint points must be on one line. To achieve the latter, it's slope (tangent) is declared and then factored into the end-1/start+1 points of the first/second curve.
*/
Slope=[-6,7];
CPS4=[
    [   // Controlpoint[N-1] is controlpoint[N]-1*Slope
        [0,0],[12,0],[15,20]-1*Slope,[15,20]
    ],
    [   // Controlpoint[1] is controlpoint[0]+2*Slope
        [15,20],[15,20]+2*Slope,[10,45],[0,45]
    ]
];

Curve=BezierCurve(CPS(),Resolution=50);

// Show the Bézier curve control points.
Animate([0,0,1,1])                // AnimationFraction determines when this is
for(Index=[0:len(CPS())-1]) // visible, also see 'Animation.scad'.
    for(Point=CPS()[Index])
        color(Color[Index],0.5)
        translate(Point)
        sphere(r=1,$fn=6);

// Make a rotational body from the polygon and highlight a 'slice'.
Animate([9,9,10,10])
ShowSlice(TX=480,TY=0,TZ=0,RX=0,RY=0,RZ=0,Thickness=0.01,Children=true,SliceColor="green",SliceAlpha=1.0,ChildColor="yellow",ChildAlpha=0.3)
translate([-20,0,0])
rotate([-90,0,0])
rotate_extrude($fn=100)
polygon(Curve);

// Show the polygon based on the curve.
Animate([8,8,10,10])
color("green",0.5)
polygon(Curve);


