/*
  This file belongs in

  <TheGHOUL/DemoFiles/>

  HankJr. 2021
  theghoul@hankjr.ca
*/

include<TheGHOUL/Config.scad>

/*
  Uncomment the module call immediately below.

  There are more to try out. Scroll down...
*/
ComplexCurve();
module ComplexCurve(){

    HR=10; // Helix radius
    HA=30; // Helix angle.
    ZZ=tan(HA)*Pi*HR/2;  // Endpoint Z-coordinate
    VM=HR*0.552/cos(HA); // Tangent Vector Magnitude
    // Pick one.
    ST=Cycle(-30,30); // Animation.
    //ST=0; // No animation...

    function TPS_R10(Transforms=[],FI=0,RI=0)=
        [ // TangentPointSet
            [ // Tangent Points
                 [[HR, 0, 0],[VM,90-HA+FI,90],[0,0,0]]
                ,[[ 0,HR,ZZ],[0,0,0],[VM,90+HA-RI,0]]
                ,[]
            ],
            Transforms
        ]
    ;

    // CurveTangentPointArray
    TPA=[   // Re-use the same TPS 4x.
             TPS_R10([              [0,0,   0,"T"]])
            ,TPS_R10([[0,0, 90,"R"],[0,0,  ZZ,"T"]])
            ,TPS_R10([[0,0,180,"R"],[0,0,2*ZZ,"T"]],0,ST)
            ,TPS_R10([[0,0,270,"R"],[0,0,3*ZZ,"T"]],ST,0)
        ]
    ;

    ShowTPA(TPA);
    //BezierCurve(TPA,30);
}

/*
  An alternative definition of the curve above, using a single TPS.
*/
//ComplexCurveTwo();
module ComplexCurveTwo(){

    HR=10; // Helix radius
    HA=30; // Helix angle.
    ZZ=tan(HA)*Pi*HR/2;  // Endpoint Z-coordinate
    VM=HR*0.552/cos(HA); // Tangent Vector Magnitude
    // Pick one.
    // ST=Cycle(-30,30); // Animation.
    ST=0; // No animation...

    function TPS_R10(Transforms=[],ST=0)=
        [ // TangentPointSet
            [ // Tangent Points
                 [[ HR,  0,   0],[VM,90-HA,    90],[0,0,0]]
                ,[[  0, HR,1*ZZ],[VM,90-HA,   180],[VM,-90-HA   ]]
                ,[[-HR,  0,2*ZZ],[VM,90-HA+ST,270],[VM,-90-HA+ST]]
                ,[[  0,-HR,3*ZZ],[VM,90-HA,     0],[VM,-90-HA   ]]
                ,[[ HR,  0,4*ZZ],[ 0,90-HA,    90],[VM,-90-HA   ]]
                ,[]
            ],
            Transforms
        ]
    ;

    // CurveTangentPointArray
    TPA=[TPS_R10([],ST)];

    ShowTPA(TPA);
    BezierCurve(TPA,30);
}

/*
  An example of a direct Control Point Set, instead of a Tangent Point Set, showing that knowledge of the control polygon in this case may not necessarily, intuitively, reveal the curve shape. With the third vertex at Y=-12, does it dip below the X-axis?

  Uncomment the module call immediately below.
*/
//Test2();
module Test2(){
    CP=[[0,0,0],[3,6,0],[6,-12,0],[9,12,0],[12,9,0]];

    BezierCurve(CP,30);
    color(BLU){
        ShowCurve(CP,0.2,1,false); // Control points.
        ShowCurve(CP,0.05,1,true); // Control polygon.
    }
}

/*
  Interestingly--and with 'hindsight', logically--when a coordinate change of one of the control points doesn't change the projection of the control polygon on a certain plane, the projection on that plane of the Bezier curve defined by the same polygon also doesn't change. In other words; if you change only Z-coordinates of one/some of the control points, the projection of the resulting Bézier curve on Z=0 does not change.

  Uncomment the module call immediately below, observe the 'top view' or Z=0 plane, and change the Z and/or ZZ value(s), then rotate the view around the X- or Y-axis.
*/
//Test3();
module Test3(){
    Z=4;
    ZZ=-2;
    CP=[[10,0,0],[10,5.52,Z],[5.52,10,ZZ],[0,10,ZZ]];
    BezierCurve(CP,10);
    color(BLU){
        ShowCurve(CP,0.2,1,false); // Control points.
        ShowCurve(CP,0.05,1,true); // Control polygon.
    }
}

//Test4();
module Test4(){
    CP=[
        [[10,0,0],[10,5.52,0],[5.52,10,0],[0,10,0]]
       ,[[0,10,0],[-5.52,10,0],[-10,5.52,0],[-10,0,0]]
    ];

    BezierCurve(CP,10);
    color(BLU){
        for(C=CP){
            ShowCurve(C,0.2,1,false); // Control points.
            ShowCurve(C,0.05,1,true); // Control polygon.
        }
    }
}

//Test5();
module Test5(){
    CP=[
        [
            [[10,0,0],[10,5.52,0],[5.52,10,0],[0,10,0]]
           ,[[0,10,0],[-5.52,10,0],[-10,5.52,0],[-10,0,0]]
        ]
       ,[
            [[-10,0,0],[-10,-5.52,0],[-5.52,-10,0],[0,-10,0]]
           ,[[0,-10,0],[5.52,-10,0],[10,-5.52,0],[10,0,0]]
        ]
    ];

    BezierCurve(CP,10,true);
    color(BLU){
        for(C=CP)for(P=C){
            ShowCurve(P,0.2,1,false); // Control points.
            ShowCurve(P,0.05,1,true); // Control polygon.
        }
    }
}
