/*
  This file belongs in

  <TheGHOUL/DemoFiles/>

  Hank J. van Leuvensteijn Jr. 2021
  theghoul@hankjr.ca
*/

include<TheGHOUL/Config.scad>

/* OPEN THE ANIMATION VIEW WITH STEPS=100 AND FPS=10. */

//$AnimSegs=10; // This is already set in config.scad
$fn=36;
$vpt=[14,7,0];
$vpr=[45,0,45];
$vpd=65;

// Some explanatory text.
color("darkslategrey")
translate([17,-6,0])
rotate([0,0,45])
linear_extrude(0.1)
{text("From Bézier curve to polygon,",font="Liberation Sans:style=Bold Italic",size=1);
translate([0,-1.5,0])
text("to rotate_extrude() object.",font="Liberation Sans:style=Bold Italic",size=1);}

// Bézier control point set
CPS=[[6,16],[9,16],[12,10],[1,6],[5,1],[5,0]];
// Offset dimension
Dist=-0.5;
// Create a set of curve points, add 'centerpoint' on Y-axis
Array=concat([[0,16]],BezierCurve(CPS,Resolution=50));
// Create an offset set of points
ArrayO=CurveOffset(Array,Dist,false);

// Show the construction of the curve
Animate([0,0,5,11])
translate([15,3,0])
ShowDeCasteljau(CPS,$AnFrac);

// Show the resulting curve
Animate([4,4,6,11])
translate([8,6,0])
// Fade in
color("red",$AnFrac)
ShowCurve(Array,0.1,1,true,false);

// Build a polygon from the two curves
module ThePolygon(){
    // polygon() needs 2D vertices.
    // Add reversed offset array and make a polygon.
    // Reversing puts the polygon points in the right order.
    polygon(
        concat(CropArray(Array),ReverseArray(CropArray(ArrayO)))
    );
}

// Show the polygon
Animate([5,5,7,11])
// Fade in
color("yellow",$AnFrac)
translate([3,3,0])
ThePolygon();

// Show the rotate_extrude()d polyhedron
Animate([6,6,9,11])
// Fade in
color("yellow",$AnFrac)
rotate_extrude(angle=360*$AnFrac)
// Mirror the polygon in the X-axis so the vase is 'upright'
scale([1,-1,1])
ThePolygon();
