/*
  This file belongs in

  <TheGHOUL/DemoFiles/>

  Hank J. van Leuvensteijn Jr. 2021
  theghoul@hankjr.ca
*/

/* OPEN THE ANIMATION VIEW WITH STEPS=100 AND FPS=10. */

include<TheGHOUL/Config.scad>

/* Use a square-ish preview window for image output. */
$vpt=[7.8,7.2,0]; $vpr=[0,0,0]; $vpd=50;

/* The nearest approximation (minimal radial deviation) to a 1/4 circle is achieved with a cubic Bézier Curve with a control point to endpoint distance of 0.552 x radius (which is 10 here), it only happens momentarily at 6.25 in the image, and for a moment at 8.75-9... */
S=5.52;

/* Some control-point time-variable parameters: */
// Mod1 keeps T on [0:1]
Turn=(
    // startvalue
    0
    // between 2.5 and 6.25, increase with 0.75 to 0.75
    +StringTee(2.5,6.25,0,0.75)
    // between 6.25 and 9, pause at 0.75
    // between 9 and 10, increase with 0.25 to 1
    +StringTee(9,10,0,0.25)
);

/* Linear motion of P1, see previous statement for explanation. */
Delta=5*(
            // 0:2:0 between 0 and 2.5
            2*sin(StringTee(0,2.5,0,180))
            // 0:-1:0 between 6.25 and 9
            -sin(StringTee(6.25,9,0,180))
        );

//                 Linear motion P1         Circular motion P2
CPS=[[0,0,0],[S+Delta,0,0],[10,10,0]+[S*cos(360*Turn),S*sin(360*Turn),0],[10,10,0]];

/* Show Bézier curve control points. */
color(BLU){
for(Point=CPS)
translate(Point)
sphere(r=0.25);
ShowCurve(CPS,0.1,1,true,false);}

/* Show the curve and polygon. */
BezierCurve(CPS,30,false);

/* Mark a point on the curve. */
Fraction=0.5;
Point=CBezierVertex(CPS,Fraction);
color(RED)
translate(Point)
sphere(r=0.22);

/* Publish some info. */
Print(["Point F = ",[Point.x,Point.y]]);

/* Add text. */
// Rotation to 'pretify' text
R=[10,20,0];
color(DSG){
    // rotate, place and adjust
    rotate(R)translate(CPS[0]+[-1.2,1,0])
    SimpleText("P0",Size=1,Thickness=0.5,Center=true,Font="Noto Mono",Spacing=1);
    rotate(R)translate(CPS[1]+[0.4,-1,0])
    SimpleText("P1",Size=1,Thickness=0.5,Center=true,Font="Noto Mono",Spacing=1);
    rotate(R)translate(CPS[2]+[2,0,0])
    SimpleText("P2",Size=1,Thickness=0.5,Center=true,Font="Noto Mono",Spacing=1);
    rotate(R)translate(CPS[3]+[0,1.2,0])
    SimpleText("P3",Size=1,Thickness=0.5,Center=true,Font="Noto Mono",Spacing=1);

    rotate(R)translate(Point+[-1,1,0])
    SimpleText("F",Size=1,Thickness=0.5,Center=true,Font="Noto Mono",Spacing=1);
}

