/*
  This file belongs in

  <TheGHOUL/DemoFiles/>

  HankJr. 2021
  theghoul@hankjr.ca
*/

include<TheGHOUL/Config.scad>

/* The nearest approximation (minimal radial deviation) to a 1/4 circle is achieved with a cubic Bézier Curve with a control point to endpoint distance of 0.552 x radius. */
R=10;
VL=R*0.552;
/* The documentation image. */
function Shape0()=
    [
        [[ // Main shape.
            [[ R, 0,0],[VL,90, 90]],    // P0
            [[ 0, R,0],[VL,90,180]],    // P1
            [[-R, 0,0],[VL,90,270]],    // P2
            [[ 0,-R,0],[VL,90,  0]]     // P3
        ],[]],
        [[ // Smile.
            [[  7, 0,0],[2,90, 90]],    // P0
            [[  4, 4,0],[1,90,210]],    // P1
            [[4.5, 0,0],[2,90,270]],    // P2
            [[  4,-4,0],[1,90,330]]     // P3
        ],[]],
        [[ // 'Displaced' smile.
            [[  7, 0,0],[2,90, 90]],    // P0
            [[  4, 4,0],[2,90,210]],    // P1
            [[4.5, 0,0],[2,90,270]],    // P2
            [[  4,-4,0],[2,90,330]]     // P3
        ],[[30,0,0,"R"],[10,0,5,"T"]]],
        [[ // Winky eye.
            [[  0, 0,0],[  2,90, 90]],  // P0
            [[0.3, 2,0],[0.5,90,180]],  // P1
            [[ -1, 0,0],[  1,90,270]],  // P2
            [[0.3,-2,0],[0.5,90,  0]]   // P3
        ],[[0,0,20,"R"],[-2,3,0,"T"]]],
        [[ // Open eye.
            [[ 2.5,   0,0],[1,90, 90]], // P0
            [[   0, 1.5,0],[1,90,180]], // P1
            [[-2.5,   0,0],[1,90,270]], // P2
            [[   0,-1.5,0],[1,90,  0]]  // P3
        ],[[-3,-3,0,"T"]]]
    ]
;

function Shape1( // Egg shaped
        VL=5,Transforms=[[0,0,0,"T"]]
    )=
    [[
        [
            [[1.65*R, 0,0],[VL,90, 90]], // P0
            [[     0, R,0],[VL,90,180]], // P1
            [[    -R, 0,0],[VL,90,270]], // P2
            [[     0,-R,0],[VL,90,  0]]  // P3
        ],
        Transforms
    ]]
;

function Shape2( // Heart shaped
        VL=5,Transforms=[[0,0,0,"T"]],U=undef
    )=
    [[
        [
            [[     R,     0,0],[  VL,90, 90]          ], // P0
            [[     0,     0,0],[2*VL,90,100],[U,90,80]], // P1
            [[    -R,     0,0],[  VL,90,270]          ], // P2
            [[     0,-1.5*R,0],[   0,90,  0]          ]  // P3
        ],
        Transforms
    ]]
;

// Shape (TPA) selector
TPA=Shape0();

// Vectors
ShowTPA(TPA);

// The shape
color(DSG,0.7)
linear_extrude(0.1)
BezierShape(TPA,10);

// Since all Bézier routines can digest the same TPA:
BezierCurve(TPA,10,true,true,0.3,1,false);
