/*
  This file belongs in

  <TheGHOUL/DemoFiles/>

  Hank J. van Leuvensteijn Jr. 2021
  theghoul@hankjr.ca
*/
include<TheGHOUL/Config.scad>

/* OPEN THE ANIMATION VIEW WITH STEPS=100 AND FPS=10. */

//$AnimSegs=10; // already set in Config.scad

//$t=0.15; // For troubleshooting

// Two Bézier curve control point sets, 'Smidge' causes the second curve to start just a bit further so the spheres representing the 'coinciding' vertex don't _actually_ coincide and two half-spheres are visible in the image. Makes for a clearer, 'much more prettier' image.
TPA1=[[[0,0],[3,0],[8,1],[10,3]]];
TPA2=[[[10+Smidge,3+Smidge],[12,5],[12,8],[10,10]]];

// The curves
color(CPR){
BezierCurve(TPA1,Radius=0.1);
ShowCurve(TPA1[0],Radius=0.2,Connect=false); // Control points
BallCylinderBetween(TPA1[0][0],TPA1[0][1],Radius=0.1,Ends="Both",$fn=$fc);
BallCylinderBetween(TPA1[0][2],TPA1[0][3],Radius=0.1,Ends="Both",$fn=$fc);}
color(DSG){
BezierCurve(TPA2,Radius=0.1);
ShowCurve(TPA2[0],Radius=0.2,Connect=false); // Control points
BallCylinderBetween(TPA2[0][0],TPA2[0][1],Radius=0.1,Ends="Both",$fn=$fc);
BallCylinderBetween(TPA2[0][2],TPA2[0][3],Radius=0.1,Ends="Both",$fn=$fc);}

// Highlight the transition
Animate(AnimVector=[0,0,5,10],Frequency=1)
// Fade in-out
color("red",$AnFlash*0.5)
BallCylinderBetween(TPA1[0][2],TPA2[0][1],Radius=0.4,Ends="Both",$fn=$fc);
