/*
  This file belongs in

  <TheGHOUL/DemoFiles/>

  HankJr. 2021
  theghoul@hankjr.ca
*/

include<TheGHOUL/Config.scad>

Torso();
//Elbow();

module Torso(){
    /* The nearest approximation (minimal radial deviation) to a 1/4 circle is achieved with a cubic Bézier Curve with a control point to endpoint distance of 0.552 x radius. */
    F=0.552;
    R=10;
    VL=F*R;

    function Chest(
            Transforms=[[0,0,0,"T"]]
        )=
        [
            [
                [[ R/2, 0,0],[VL,90, 90],[],[1,0,0],[0]],
                [[   0, R,0],[VL,90,180],[],[1,0,0],[0]],
                [[  -R, 0,0],[VL,90,270],[],[1,0,0],[0]],
                [[   0,-R,0],[VL,90,  0],[],[1,0,0],[0]]
            ],
            Transforms
        ]
    ;

    function Shoulders(
            Transforms=[[0,0,R,"T"]]
        )=
        [
            [
                [[ 0.75*R, 0,0],[VL,90, 90],[],[6,  0,  0],[6]],
                [[      0, R,0],[VL,90,180],[],[6, 10, 90],[6]],
                [[     -0.75*R, 0,0],[VL,90,270],[],[6,-30,180],[6]],
                [[      0,-R,0],[VL,90,  0],[],[6, 10,270],[6]]
            ],
            Transforms
        ]
    ;

    function Neck(
            Transforms=[[0,0,2*R,"T"]]
        )=
        [
            [
                [[ R/2,   0,0],[VL/2,90, 90],[],[0,0,0],[5]],
                [[   0, R/2,0],[VL/2,90,180],[],[0,0,0],[5]],
                [[-R/2,   0,0],[VL/2,90,270],[],[0,0,0],[5]],
                [[   0,-R/2,0],[VL/2,90,  0],[],[0,0,0],[5]]
            ],
            Transforms
        ]
    ;

    HalfTorso=[
        Chest(),
        Shoulders(),
        Neck()
    ];

    Wobble([30,0,60],[0,0,40],[1,1,2])
    translate([0,0,-10]){
    ShowTPA(HalfTorso);
    color(CPR,0.7)
    BezierSolid(HalfTorso,20,20);
    BezierCurve(HalfTorso,20,Closed=true);
}

}


module Elbow(){

    function TPS_R(Transforms=[],R=10,RB=20,NM=1,PM=0,NI=0,SRO)=
        [ // Tangent Point Plane (a closed curve cross-section)
            [ // Tangent Points
                 [[ R-RB,   0,0],[0.552*R,90, 90],[],[0.552*(RB-R)*NM,NI,0],[0.552*(RB-R)*PM]]
                ,[[  -RB,R,0],[0.552*R,90,180],[],[  0.552*(RB)*NM,NI,0],[  0.552*(RB)*PM]]
                ,[[-R-RB, 0,0],[0.552*R,90,270],[],[0.552*(RB+R)*NM,NI,0],[0.552*(RB+R)*PM]]
                ,[[  -RB,-R,0],[0.552*R,90,  0],[],[  0.552*(RB)*NM,NI,0],[  0.552*(RB)*PM]]
            ],
            // SRO is Set Resolution Override, e.g., smaller resolution for close spaced sets.
            Transforms,SRO
        ]
    ;

    function TPA(R=10,W=1,RB=20,SRO=4)=[
        TPS_R([],R,RB,1,0,0),
        TPS_R([[0,90,0,"R"]],R,RB,0,1,0,SRO),
        TPS_R([[0,90,0,"R"]],R-W,RB,1,0,180),
        TPS_R([],R-W,RB,0,1,180,SRO)
    ];

    ShowTPA(TPA());
    color(OSG,0.5)
    BezierSolid(TPA(),30,30,Doughnut=true);

    rotate([90,0,0])
    Torus(20,90)
    Ring(10,1,Centered=true);
}
