/*
  This file belongs in

  <TheGHOUL/DemoFiles/>

  Hank J. van Leuvensteijn Jr. 2021
  theghoul@hankjr.ca
*/

include<TheGHOUL/Config.scad>
$fn=36;
/* OPEN THE ANIMATION VIEW WITH STEPS=100 AND FPS=10. */

//$t=0.25; // Troubleshooting.

/* Uncomment ONLY ONE definition... */
function Fx(X)=
    BezierTransitionDown(0,0.1,0.9,0.9,Frac=X)
//    BezierTransitionDown(1,0.8,0.5,0,Frac=X)
//    BezierTransitionUp(0.5,1,0.5,0,Frac=X)
;

// Show the function Fx(X)
translate([0,0,-0.1])
ShowFx(Domain=[0,1],Resolution=50,DotSize=0.01,Margin=0.2);

// Display a CS
translate([-0.3,-0.3,0])
CoordinateSystem(Size=0.2,Thickness=0.015);

// Make beautiful things and eye candy
Animate([0,0,10]){

    // The rotating 'capsule', the rotation is the function value
    union(){
        translate([1.3,Fx($AnFrac),0])
        rotate([0,0,Fx($AnFrac)*360]){
            color(ORD)
            BallCylinderBetween([-0.1,0,0],[0.1,0,0],Radius=0.05);
            color(OSG)
            translate([0.101,0,0])
            sphere(r=0.05);
        }
    }

    color(DCN){
        // Move a vertex along the function
        translate([$AnFrac,Fx($AnFrac),0])
        sphere(r=0.025);
        // Drop a line down to the X-value
        BallCylinderBetween([$AnFrac,-0.05,0],[$AnFrac,Fx($AnFrac),0],Radius=0.01);
        // Draw a line at Fx(X) (i.e., the Y-value) to capsule
        BallCylinderBetween([$AnFrac,Fx($AnFrac),0],[1.3,Fx($AnFrac),0],Radius=0.01);
    }
}

