/*
  This file belongs in

  <TheGHOUL/DemoFiles/>

  HankJr. 2021
  theghoul@hankjr.ca
*/

include<TheGHOUL/Config.scad>

/* The nearest approximation (minimal radial deviation) to a 1/4 circle is achieved with a cubic Bézier Curve with a control point to endpoint distance of 0.552 x radius. */
F=0.552;
R=10;

CP=[[R, 0], [R, F*R], [F*R, R], [0, R]];
translate(CBezierVertex(CP,0.75))
sphere(r=0.5,$fn=$fc);

color(DSG,0.25)
ShowCurve(BezierCurve(CP),0.5,1,true,false);

