include<TheGHOUL/Config.scad>
$fn=36;
// Set a viewpoint
VPT=[0, [3.4, 2.7, 1.5], [55, 0, 25], 20];
$vpt=VPT[1];
$vpr=VPT[2];
$vpd=VPT[3];

// Base vector
ORG=[0,0,0];
// Animated angle
A=$t*360;


// Bisect ===================

A_1=(A+0)%360; // Angle offset (here 0)
MV_1=[0,0,0]; // Base point (where to move vector-set in display)
L_1=2; // Vector length

U_1=[0,1,0]*L_1; // Fixed (red) vector
V_1=ORG; // Base vector
W_1=[cos(A_1),sin(A_1),0]*L_1; // Rotating (blue) vector (animation)

B_1=Bisect(U_1,V_1,W_1)*L_1; // bisecting vector

Arrow(B_1,Points=[0,0.3,1],Thickness=0.2,Base=MV_1); // Bisector
color(RED,0.4)
Arrow(U_1,Points=[0,0.3,1],Thickness=0.2,Base=MV_1); // Fixed
color(BLU,0.4)
Arrow(W_1,Points=[0,0.3,1],Thickness=0.2,Base=MV_1); // 'Rotator'

// Some text
color(GPG)
translate(MV_1+[1,1.5,1])
rotate($vpr) // To face the screen.
rotate([15,25,0]) // To 'prettify'.
SimpleText("Bisect()",0.3,Thickness=0.1,Center=true,Font="Noto Mono",Spacing=1);

// BisectObtuse =================== SEE COMMENTS AT 'Bisect' ABOVE

A_2=(A+80)%360;
MV_2=[0,5,0];
L_2=2;

U_2=[0,1,0]*L_2;
V_2=ORG;
W_2=[cos(A_2),sin(A_2),0]*L_2;

B_2=BisectObtuse(U_2,V_2,W_2)*L_2;

Arrow(B_2,Points=[0,0.3,1],Thickness=0.2,Base=MV_2);
color(RED,0.4)
Arrow(U_2,Points=[0,0.3,1],Thickness=0.2,Base=MV_2);
color(BLU,0.4)
Arrow(W_2,Points=[0,0.3,1],Thickness=0.2,Base=MV_2);

color(GPG)
translate(MV_2+[0.2,1.5,1])
rotate($vpr)
rotate([15,25,0])
SimpleText("BisectObtuse()",0.3,Thickness=0.1,Center=true,Font="Noto Mono",Spacing=1);

// BisectLeft =================== SEE COMMENTS AT 'Bisect' ABOVE

A_3=(A+160)%360;

MV_3=[4,3,0];
L_3=2;

U_3=[0,1,0]*L_3;
V_3=ORG;
W_3=[cos(A_3),sin(A_3),0]*L_3;

B_3=BisectLeft(U_3,V_3,W_3)*L_3;

Arrow(B_3,Points=[0,0.3,1],Thickness=0.2,Base=MV_3);
color(RED,0.4)
Arrow(U_3,Points=[0,0.3,1],Thickness=0.2,Base=MV_3);
color(BLU,0.4)
Arrow(W_3,Points=[0,0.3,1],Thickness=0.2,Base=MV_3);

// A sector of an imaginary 'polygon body'
color(GRN,0.4)
translate(MV_3)
SectorSlice(A_3,90,L_4+Cut,0.01+Cut,Centered=true)
cylinder(r=L_4,h=0.01);

color(GPG)
translate(MV_3+[2.3,-3.1,1])
rotate($vpr)
rotate([15,25,0])
SimpleText("BisectLeft()",0.3,Thickness=0.1,Center=true,Font="Noto Mono",Spacing=1);

// BisectRight =================== SEE COMMENTS AT 'Bisect' ABOVE

A_4=(A+240)%360;

MV_4=[4,8,0];
L_4=2;

U_4=[0,1,0]*L_4;
V_4=ORG;
W_4=[cos(A_4),sin(A_4),0]*L_4;

B_4=BisectRight(U_4,V_4,W_4)*L_4;

Arrow(B_4,Points=[0,0.3,1],Thickness=0.2,Base=MV_4);
color(RED,0.4)
Arrow(U_4,Points=[0,0.3,1],Thickness=0.2,Base=MV_4);
color(BLU,0.4)
Arrow(W_4,Points=[0,0.3,1],Thickness=0.2,Base=MV_4);

// A sector of an imaginary 'polygon body'
color(GRN,0.4)
translate(MV_4)
SectorSlice(A_4,90,L_4+Cut,0.01+Cut,Centered=true)
cylinder(r=L_4,h=0.01);

color(GPG)
translate(MV_4+[2.3,-3.1,1])
rotate($vpr)
rotate([15,25,0])
SimpleText("BisectRight()",0.3,Thickness=0.1,Center=true,Font="Noto Mono",Spacing=1);

