/*
  This file belongs in

  <TheGHOUL/DemoFiles/>

  Hank J. van Leuvensteijn Jr. 2021
  theghoul@hankjr.ca
*/

include<TheGHOUL/Config.scad>

//$t=0.59; // Troubleshooting
$AnimSegs=5;
Seg=$AnimSegs*$t;
// Obvious?
EchoViewPort();

// Define a viewport sequence
MyView=ViewPort([
[0,[0,0,0],[60,0,45],30],
[1.5,[0,0,0],[60,0,45],30],
[2.5,[0,0,0],[120,0,-45],30],
[3,[0,0,0],[60,0,45],30],
[4,[0,0,0],[60,0,180],30],
[4.5,[0,0,0],[120,0,270],30],
[5,[0,0,0],[60,0,45],30]
]);

// Implement MyView
$vpt=MyView[1];
$vpr=MyView[2];
$vpd=MyView[3];

// Ellipse
// Disappearing half
Animate([0,0,1,1]) // Animate some aspect of this object
color(DSG,$AnOmega) // Animate color (increasing transparency)
translate([0,0,-Tad]) // Avoid coincidence artifacts with persistent half
linear_extrude(Smidge)
Ellipse(3,6,Centered=true);
// Persistent half
if(Seg>1) // No animation for this object, just visibility
color(DSG,0.5)
linear_extrude(Smidge)
PosX2D(15)
Ellipse(3,6,Centered=true);
// Persistent half extruded
Animate([1,1,2,2.5]) // Animate some aspect of this object
rotate([90,0,0])
color(DSG,0.5)
rotate_extrude(angle=180*$AnFrac,convexity=2) // Animate extrusion (linear)
PosX2D(15)
Ellipse(3,6,Centered=true);

// Ring
// Disappearing half
Animate([2.5,2.5,3,3]) // Animate some aspect of this object
color("gold",BezierTCDown(0.1,0.1,0.9,0.9)) // A different transparency increase
translate([0,0,-Tad])
linear_extrude(Smidge)
Ring(5,0.5,Centered=true);
// Persistent half
if(2.5<Seg&&Seg<3.5) // No animation for this object, just visibility
color("gold")
linear_extrude(Smidge)
PosX2D(15)
Ring(5,0.5,Centered=true);
// Persistent half extruded
Animate([3.5,3.5,4.5,5]) // Animate some aspect of this object
rotate([90,0,0])
color("gold",0.4+0.6*BezierTCDown(0.1,0.1,0.9,0.9)) // Transparency increase
rotate_extrude(angle=0.1+179.9*$AnFrac,convexity=2)
PosX2D(15)
Ring(5,0.5,Centered=true);
