/*
  This file belongs in

  <TheGHOUL/DemoFiles/>

  Hank J. van Leuvensteijn Jr. 2021
  theghoul@hankjr.ca
*/

include<TheGHOUL/Config.scad>

$AnimSegs=4;
$vpt=[0,0,0];$vpr=[45,0,30];$vpd=80;

color(RED)
linear_extrude(2,scale=0)
Star(12,5,Schlaefli=4,Centered=true);

/*
  It's a trap! No; it's a trick... By giving color() a scope (the curly brackets) the special variables Animate() provides for it's children() become available within that scope. We can now access the value of those, and use them directly.
*/

Animate([0,0,1,4])
color(DSG){
    No=floor(8*$AnFrac); // Integer stepped value
    CircularArray(Radius=8,IncludedAngle=360/8*(No-1),Number=No,Start=0,Static=false)
    linear_extrude(1,scale=0)
    ArrowHead(3,3,1);
}

Animate([1.1,1.1,2,4])
color(SVR){
    No=floor(8*$AnFrac);
    CircularArray(Radius=9,IncludedAngle=360/8*(No-1),Number=No,Start=22.5,Static=false)
    linear_extrude(0.5,scale=0)
    ArrowHead(1.5,1.5,0.5);
}

Animate([2.1,2.1,3,4])
color(RED){
    No=floor(16*$AnFrac);
    CircularArray(Radius=15,IncludedAngle=360/16*(No-1),Number=No,Static=true)
    linear_extrude(0.5,scale=0.8)
    SVG_Shape(DemoShapes,"MapleLeaf",Size=[5/4000,5/4000],Center=true,Home=false);
}

translate([-25,0,0])
CoordinateSystem(Size=4,Thickness=0.4,Points=[0,0.3,1],Polar=false);
