/* You gotta get The GHOUL. */
include<TheGHOUL/Config.scad>

//$t=0;
/*
VPT=[0,[0,0,0],[50,30,30.7],120];
$vpt=VPT[1];
$vpr=VPT[2];
$vpd=VPT[3];
*/
// For 'flip-flop' GIFs illustrating two distinct conditions; *Flop* alternates between _0_ and _1_, switching at start- and half-time.
Flop=
false // true=animate, false=static <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
?round($t):0;

$fn=0;
$fa=1;
$fs=0.4;

CS=Segments(Radius=1);
echo(CS);
echo(360/CS);
echo(ArcAngles(0,180,Radius=1));

TTotal=40;
Pinion=7;
Wheel=TTotal-Pinion;
DP=0.5;
WShake=0.1*Flop+.05; // <<<<<<<< Fiddle with this, *Flop* dependent and not.
PShake=-0.1*Flop; // <<<<<<<<
Tip=0;
WRootClearance=0.05;
PRootClearance=0.05;
WheelPR=Wheel/DP/2;
PinionPR=Pinion/DP/2;
GenR=Pinion/DP/4;
TAngle=(1/2-WShake)*180/Wheel;
TD=_GenData(WheelPR,GenR,1/1000/DP,0,TAngle,0,1/10/DP,GenR);

// true=animate, false=static <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
rst=true?$t:0;
WhlRot=360/Wheel*rst;
PinRot=-360/Pinion*rst;

// Mesh odd-leaved pinions.
OddP=IsOdd(Pinion)?0.5:0;

// Meshpoint data.
MPL=0.73; // Depends on DP???
Alpha=$t/MPL*TD[0]*WheelPR/GenR;
DaP=GenR*[1-cos(Alpha),sin(Alpha),0];
Blpha=360/Wheel*($t-1);
DoP=WheelPR*[cos(Blpha)-1,sin(Blpha),0];

// Gears and stuff, contact point, circles... ==================================
if(true){ // 'false'=off, 'true'=on.

translate([GenR,0,0])
Arc(180,-TD[0]*WheelPR/GenR,GenR,0.06,$fn=60);
translate([-WheelPR,0,0])
Arc(0,360/Wheel*(MPL-1),WheelPR,0.06,$fn=60);

// Meshpoint.
if($t<MPL)
color(RED)
translate(DaP)
sphere(0.1);
else
color(BLU)
translate(DoP)
sphere(0.1);

// Line of centres.
BallCylinderBetween([-WheelPR,0,-0.2],[PinionPR,0,-0.2],Radius=0.025);

// Pitch Circles
PCRP=Pinion/DP/2;
color(GRN)
translate([PCRP,0,0])
Arc(0,360,PCRP,0.05,$fn=60);

PCRW=Wheel/DP/2;
color(BLU)
translate([-PCRW,0,0])
Arc(0,360,PCRW,0.05,$fn=120);

// Generating circle.
color(RED)
translate([PCRP/2,0,0])
Arc(0,360,PCRP/2,0.05);

// Gears.
translate([-Wheel/DP/2,0,-5])
rotate([0,0,WhlRot])
ClockWheel(Wheel,Pinion,DP,WShake,Tip,WRootClearance,4,"Gear",4,DSG);

translate([Pinion/DP/2,0,-5])
rotate([0,0,PinRot])
ClockPinion(Wheel,Pinion,DP,PShake,Tip,PRootClearance,1,"Pinion",WShake,4,CPR,OddP);
} // ===========================================================================

*color(CPR)
CamWheel(OD=10,Cams=3,Step=2,ID=1,Rake=5);

*difference()
{
rotate([0,0,0])
ChainWheel(Resolution=0.4);
color(DSG)
translate([0,0,50])
cube([100,100,100],center=true);
}

*ChainWheel();

if(false){
translate([0,0,-1])
EOTWheel(40,50,5,0.2,3);
*Arc(0,360,10,0.5);
*Arc(0,360,28.6183,0.5);
*Arc(0,360,50,0.5);
// add month radials

}

*LanternGear();

// Background.
translate([0,0,-10])
color(DSG,0.3)
circle(500);

