/*
  This file belongs in

  <TheGHOUL/DemoFiles/>

  Hank J. van Leuvensteijn Jr. 2021
  theghoul@hankjr.ca
*/

include<TheGHOUL/Config.scad>

/*
  This file demonstrates artifacts that appear in preview when 'convexity' is set too low. Also see the OpenSCAD manual entry on the subject.
*/

// Set Convexity to 1 or 2 and observe. <<<<<<<<<<<<<<<<<<<<<<==================
Convexity=1;
// <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<==================

// The artifact we're trying to demonstrate here depends on object size, alignment and viewpoint (it's always there, but certain viewing angles make it more obvious) this is the optimum viewpoint. Ish.
$vpt=[0,0,0];
$vpr=[46,0,215];
$vpd=40;

// Cut a ring-shaped groove from a cuboid.
difference(){
    cube([11,11,4],center=true);
    color(DSG)
    // The artifact depends on object size and alignment (it's always there, but certain viewing angles make it more obvious) *7* in this call makes it look good.
    linear_extrude(7,convexity=Convexity)
    Ring(5,1);
}

// Some illustrative text.
color(DSG)
translate([0,5.5,0.75])
rotate([90,0,180])
SimpleText("Convexity",1,Thickness=0.1,Center=true,Font="Noto Mono",Spacing=1);

if(Convexity==1)
color(DSG)
translate([0,5.5,-0.75])
rotate([90,0,180])
SimpleText("incorrect.",1,Thickness=0.1,Center=true,Font="Noto Mono",Spacing=1);

if(Convexity!=1)
color(DSG)
translate([0,5.5,-0.75])
rotate([90,0,180])
SimpleText("correct.",1,Thickness=0.1,Center=true,Font="Noto Mono",Spacing=1);

