/*
  This file belongs in

  <TheGHOUL/DemoFiles/>

  Hank J. van Leuvensteijn Jr. 2021
  theghoul@hankjr.ca
*/

include<TheGHOUL/Config.scad>

$vpt=[0,0,0];
$vpr=[80,0,300];
$vpd=70;

$AnimSegs=5;

// Polygon with 'Transform' parameter (see 'TransformMatrix()').
function Pollie(
        Transforms=[[0,0,0,"T"]]
    )=
    AffineTransform(
        TransformMatrix(Transforms),
        [
            [5,4,0],[4,5,0],[-4,5,0],[-5,4,0],[-5,-4,0],[-4,-5,0],[4,-5,0],[5,-4,0]
        ]
    )
;

// Mesh of the solid.
function PollieSolid(Frc=1)=
    [
        Pollie([[-10*Frc,0,0,"T"],[0,45*Frc,0,"R"]]),
        Pollie([[-10*Frc,0,0,"T"],[0,135*Frc,0,"R"]]),
        Pollie([[-10*Frc,0,0,"T"],[0,225*Frc,0,"R"]]),
        Pollie([[-10*Frc,0,0,"T"],[0,315*Frc,0,"R"]])
    ]
;

// Mesh of the solid, offset inward to simulate different color interior.
function QollieSolid(Frc=1)=
    [
        Pollie([[0.99,0.99,1,"S"],[-10*Frc,0,0,"T"],[0,45*Frc,0,"R"]]),
        Pollie([[0.99,0.99,1,"S"],[-10*Frc,0,0,"T"],[0,135*Frc,0,"R"]]),
        Pollie([[0.99,0.99,1,"S"],[-10*Frc,0,0,"T"],[0,225*Frc,0,"R"]]),
        Pollie([[0.99,0.99,1,"S"],[-10*Frc,0,0,"T"],[0,315*Frc,0,"R"]])
    ]
;

// Mesh of last leg of the solid.
RollieSolid=[
    Pollie([[-10,0,0,"T"],[0,315,0,"R"]]),
    Pollie([[-10,0,0,"T"],[0,45,0,"R"]])
];

// Unfold the mesh curves (cross-sections of the solid)
Animate(AnimVector=[0,0,1,4])
color(OSG)
for(Curve=PollieSolid($AnFrac))
ShowCurve(Curve,0.15,Closed=true,Connect=true);

// Generate mesh and 'polyhedron()'.
/*
  Multi-colored exterior, first three legs. Because *Closed*=_false_, the last leg isn't covered. Because *Endcaps*=_false_, it remains 'open' at the ends.
*/
Animate(AnimVector=[1,1,2,4])
ShowMesh(PollieSolid(),false,false,0,$AnFrac,Mono=undef);
// Gold interior, same as previous but offset inwards.
Animate(AnimVector=[1,1,2,4])
ShowMesh(QollieSolid(),false,false,0,$AnFrac,Mono=[OSG]);
// Transparent multi-colored last exterior section.
Animate(AnimVector=[2,2,3,4])
ShowMesh(RollieSolid,false,false,0,$AnFrac,undef,0.3);

// Purple covered mesh fading to solid color
Animate(AnimVector=[3,3,4.5,4.5])
color(PRP,0.3+0.7*$AnFrac)
CoverMesh(PollieSolid(),Endcaps=false,Closed=true,Convexity=10);

// Bare mesh fading to invisible
Animate(AnimVector=[4,4,4.5,4.5])
color(OSG,1-$AnFrac)
for(Curve=PollieSolid())
ShowCurve(Curve,0.15,Closed=true,Connect=true);

// Purple covered mesh fading to invisible
Animate(AnimVector=[4.5,4.5,5,5])
color(PRP,1-$AnFrac)
CoverMesh(PollieSolid(),Endcaps=false,Closed=true,Convexity=10);
