/*
  This file belongs in

  <TheGHOUL/DemoFiles/>

  Hank J. van Leuvensteijn Jr. 2021
  theghoul@hankjr.ca

  Nothing that happens here merits explanation. Just read the documentation and comments in the actual routines and functions that are used here if something doesn't make sense or it's not clear to you what happens here.
*/

include<TheGHOUL/Config.scad>

$vpt=[2,6,0];
$vpr=[55,0,40];
$vpd=35;

// For a purrdy UCS
CoordinateSystem(Size=1.5,Thickness=0.1,Points=[0,0.4,1],Polar=false);

// Positive X rotation
color("blue")
ArrowArc(0,60,1.8,Thickness=0.1,Points=[0,0.5]);

// Positive Y rotation
rotate([0,-90,-90])
color("green")
ArrowArc(0,60,1.8,Thickness=0.1,Points=[0,0.5]);

// Positive Z rotation
rotate([90,0,90])
color("red")
ArrowArc(0,60,1.8,Thickness=0.1,Points=[0,0.5]);

// XYZ Object dimension naming convention
translate([3,3,0]){

    Dimension([0,0,0],[2,0,0],Type="H",Text="  Width",Spacing=1,Direction="R",Extension=0.5,Location="B",Marks="A",MSize=0.5);

    Dimension([2,0,0],[2,3,0],Type="V",Text=" Length",Spacing=1,Direction="R",Extension=0.5,Location="B",Marks="A",MSize=0.5);


    rotate([0,-90,90])
    Dimension([0,0,0],[1,0,0],Type="H",Text="Height",Spacing=1,Direction="R",Extension=0.5,Location="A",Marks="A",MSize=0.5,Outside="true");

    color(DOG,0.5)
    cube([2,3,1]);
}
