/*
  This file belongs in

  <TheGHOUL/DemoFiles/>

  Hank J. van Leuvensteijn Jr. 2021
  theghoul@hankjr.ca
*/

include<TheGHOUL/Config.scad>

/*
  This is SimpleCircleText() with one line of added code to make the letters 'undulate', well, anyway, they're leaning at varying angles....
*/
module UndulatingSimpleCircleText(String,Size,Radius,Azimuth,Thickness=0.1,Center=false,CW=false,Font="Noto Mono",Spacing=1)
{

    // Generate character widths array.
    Track=MapString(String,MonoTrack);
    // Generate character kerning array. Not yet implementated.
    Kern=MapString(String,MonoKern);
    // Generate character kerning array. Not yet implementated.
    _Track=[ for(I=[0:len(Track)-1]) Track[I] ];
    // Correct Radius for text height.
    _Radius=Radius-Size/2;

    TotalWidth=(ArraySum(_Track))*Size*Spacing;
    TotalAngle=TotalWidth/Tau/_Radius*360;
    // Check for room.
    SpaceAngle=Size*Spacing/Tau/_Radius*360;
    ErrorOnTrue(str("String does not fit on Radius, total required angle is ",TotalAngle+SpaceAngle*2,"."),TotalAngle>360-SpaceAngle*2);

    /*
      Characters are generated, translated to [character center, +/- radius,0] where + or - is determined by CW or CCW, rotated into position in the string, then string is rotated depending on *Center*= true or false.
    */
    // Correct Azimuth to positive X-axis and center text if required.
    rotate([0,0,(CW?-90:90)+(Center?-TotalAngle/2:0)*(CW?-1:1)])
    for(Character=[0:len(String)-1])
        // Row characters up on radius. === TODO kerning implementation
        rotate([0,0,(ArraySum(_Track,0,Character)-Track[0]+Kern[0])*Size*Spacing/Tau/_Radius*360*(CW?-1:1)])
        /*
          Put character BASELINE on radius and centered on Y-axis. The baseline is the line on which the characters 'sit' or 'stand'. This yields quite different results for CW and CCW; the user can compensate for this with *Radius* and *Spacing*.
        */
        translate([-Kern[Character]*Size*Spacing,CW?Radius:-Radius,0])
/*
  'Undulate'... This is the only difference with the original SimpleCircleText().
*/
rotate([60+30*sin(2*(ArraySum(_Track,0,Character)-Track[0]+Kern[0])*Size*Spacing/Tau/_Radius*360),0,0])

        // Generate character
        linear_extrude(Thickness)
        text(String[Character],size=Size,font=Font);

}

//$t=0.5; // Troubleshooting.

Font="Courier 10 Pitch";

$AnimSegs=5;
Animate(AnimVector=[-0.001,-0.001,5],Frequency=0)
rotate([$AnFlash*30,0,-$AnFrac*360])
{
    color("white")
    translate([0,0,1.8])
    rotate([0,0,180])
    SimpleText("GHOUL",1,Thickness=0.3,Center=true,Font=Font,Spacing=1);

    translate([0,0,3])
    UndulatingSimpleCircleText("GHOUL the Great Helpful OpenSCAD Unified Library",0.5,4.5,180,Thickness=0.2,Center=true,CW=false,Font=Font,Spacing=1);

    color("black",0.5)
    rotate([0,0,90])
    translate([0,0,2])
    SimpleCircleText("GHOUL",1,3.2,Thickness=0.05,Center=true,CW=true,Font=Font,Spacing=0.75);

    color("black",0.5)
    rotate([0,0,-90])
    translate([0,0,2])
    SimpleCircleText("GHOUL",1,4,Thickness=0.05,Center=true,CW=false,Font=Font,Spacing=0.9);

    color("white")
    translate([0,0,1])
    SimpleBarrelText("GHOUL the Great Helpful OpenSCAD Unified Library",0.6,5,0,Thickness=0.3,Center=true,Font=Font,Spacing=1,Raise=-0.2);

    color("darkslategrey",0.5)
    cylinder(r=5,h=2);
}

