/* You gotta get The GHOUL. */
include<TheGHOUL/Config.scad>

/*
  Interesting points are at T= 0, 2.5, 5.0, 7.5. T=0 and 5.0 is when a tooth of either cog is bisected by the center-center-line, the other two are when a contact point crosses this line.
*/

//$t=0.9; // Troubleshooting

VPT=[0,[-5,0,0],[42,0,30],50];
$vpt=VPT[1];
$vpr=VPT[2];
$vpd=VPT[3];

/* Curve thickness. */
CR=0.2;

/* Some parameters. */
Teeth=18;
Ratio=3;
Teeth2=round(Teeth*Ratio); //Just in case
Module=3;
PressureAngle=20;
Addendum=1;
Dedendum=1.25;

/* Some math. */
PitchRadius=Module*Teeth/2;
PitchAngle=Deg(Tau/Teeth);
Pitch=PitchRadius*Tau/Teeth;
TipRadius=PitchRadius+Module*Addendum;
RootRadius=PitchRadius-Module*Dedendum;
BaseRadius=PitchRadius*cos(PressureAngle);
PitchRadius2=Module*Teeth2/2;
PitchAngle2=Deg(Tau/Teeth2);
BaseRadius2=PitchRadius2*cos(PressureAngle);

/* The two 'Lines of Action'. */
color(DRD)
translate([0,0,0.55])
{CylinderBetween(
    BaseRadius*[cos(PressureAngle),-sin(PressureAngle)]-[PitchRadius,0],
    BaseRadius2*[-cos(PressureAngle),sin(PressureAngle)]+[PitchRadius2,0],
    Radius=CR/2,$fn=6);
CylinderBetween(
    BaseRadius*[cos(PressureAngle),sin(PressureAngle)]-[PitchRadius,0],
    BaseRadius2*[-cos(PressureAngle),-sin(PressureAngle)]+[PitchRadius2,0],
    Radius=CR/2,$fn=6);}

/* Driving side contact points. */
SR=0.4; // Sphere radius.
V=[sin(PressureAngle),cos(PressureAngle),0];
color(RED)
translate([0,0,0.5]){
    StringTee(8.8,10,-7.735,-6.65,false,false)
    translate(V*$StValue)
    sphere(r=SR);

    StringTee(0,10,-6.65,2.2,false,false)
    translate(V*$StValue)
    sphere(r=SR);

    StringTee(0,5.1,2.2,6.75,false,false)
    translate(V*$StValue)
    sphere(r=SR);
}
/* Backside contact points. */
W=[-sin(PressureAngle),cos(PressureAngle),0];
color(CYN)
translate([0,0,0.5]){
    StringTee(4.9,10,-6.95,-2.2,false,false)
    translate(W*$StValue)
    sphere(r=SR);

    StringTee(0,10,-2.2,6.65,false,false)
    translate(W*$StValue)
    sphere(r=SR);

    StringTee(0,1.3,6.65,7.8,false,false)
    translate(W*$StValue)
    sphere(r=SR);
}

/* A legend.. */
color(DGN)
    ScreenPosition([-7,4,3],40,40)
    Arc(100,160,1,CR/2,FN=6,Pattern=[0.5,0.5]);
color(DRD)
    ScreenPosition([-8,6.5,3],40,40)
    CylinderBetween([0,-1,0],[0,1,0],Radius=CR/4);
color(DSG){
    ScreenText(Text="Base Circle",Location=[-4.2,4,3],Rotation=[5,5,0],Size=0.55,Thickness=0.5,Color=DSG,_SizeCompensation=40,_ScreenFactor=40,_Correction=[0,0,0]);
    ScreenText(Text="Line of Action",Location=[-3.5,6.5,3],Rotation=[5,5,0],Size=0.55,Thickness=0.5,Color=DSG,_SizeCompensation=40,_ScreenFactor=40,_Correction=[0,0,0]);
}

/* Some circles. */
translate([-PitchRadius,0,0.5])
{
*color(DBL) // tip
    Arc(0,360,PitchRadius+Addendum*Module,CR,FN=6);
*color(DSG) // pitch
    Arc(0,360,PitchRadius,CR,FN=6);
*color(DGN) // base
    Arc(0,360,BaseRadius,CR,FN=6);
color(DGN) // base dashdot
    Arc(0,360,BaseRadius,CR,FN=6,Pattern=[3,3]);
*color(OSG) // root
    Arc(0,360,PitchRadius-Dedendum*Module,CR,FN=6);
*color(RED) // 'pitch minus addendum'
    Arc(0,360,PitchRadius-Addendum*Module,CR,FN=6);
}
translate([PitchRadius2,0,0.5])
{
*color(DBL) // tip
    Arc(0,360,PitchRadius2+Addendum*Module,CR,FN=6);
*color(DSG) // pitch
    Arc(0,360,PitchRadius2,CR,FN=6);
*color(DGN) // base
    Arc(0,360,BaseRadius2,CR,FN=6);
color(DGN) // base dashdot
    Arc(0,360,BaseRadius2,CR,FN=6,Pattern=[3,3]);
*color(OSG) // root
    Arc(0,360,PitchRadius2-Dedendum*Module,CR,FN=6);
*color(RED) // 'pitch minus addendum'
    Arc(0,360,PitchRadius2-Addendum*Module,CR,FN=6);
}

/* The gears. */
translate([-PitchRadius,0,0])
rotate([0,0,PitchAngle*$t])
InvoluteGear(Module,Teeth,Addendum,Dedendum,0,PressureAngle,0,"Pinion");

color(CPR)
translate([PitchRadius2,0,0])
rotate([0,0,-PitchAngle2*(0.5+$t)])
InvoluteGear(Module,Teeth2,Addendum,Dedendum,0,PressureAngle);
