/*
  This file belongs in

  <TheGHOUL/DemoFiles/>

  Hank J. van Leuvensteijn Jr. 2021
  theghoul@hankjr.ca

*/

include<TheGHOUL/Config.scad>

VPT=[0,[0,0,0],[40,0,30],40];
$vpt=VPT[1];
$vpr=VPT[2];
$vpd=VPT[3];

//$t=0.5; // Troubleshooting.

/* Some settings. */
Teeth=18;
Module=1;
Addendum=1;
Dedendum=1.25;
Shift=0;
PitchRadius=Module*Teeth/2;
PitchAngle=360/Teeth;
Pitch=PitchRadius*Tau/Teeth;
PressureAngle=20;
BaseRadius=PitchRadius*cos(PressureAngle);

// Animation parameters
// Linear or Rock and roll == comment out ONE of the next two lines ============
Ra=$t*2; Ro=0;
//Ra=0; Ro=Pitch*(sin($t*360)*2);

// The gear.
translate([-PitchRadius,0,0])
rotate([0,0,-Ra*PitchAngle])
InvoluteGear(Module,Teeth,Addendum,Dedendum,0,PressureAngle);

// The rack.
color(RED,0.5)
translate([-PitchRadius,0,0])
rotate([0,0,Ro/Pi/PitchRadius*180])
translate([0,-(Ra)*Pitch,0])
translate([PitchRadius,-Ro+Pitch*5.5,0])
rotate([0,0,180])
Rack(Module,Teeth,Addendum,Dedendum,Shift,PressureAngle,0,"",0.1,0.2,1);

// Some circles.
*color(DSG,0.3)
translate([-PitchRadius,0,0])
{
    Arc(0,360,BaseRadius,0.2,FN=6);

    Arc(0,360,PitchRadius,0.2,FN=6);

    Arc(0,360,PitchRadius+2*PitchRadius/Teeth*Addendum,0.2,FN=6);
}

