/*
  This file belongs in

  <TheGHOUL/DemoFiles/>

  Hank J. van Leuvensteijn Jr. 2021
  theghoul@hankjr.ca

*/
/*
  Normally, gears in TheGHOUL are linear_extrude()-d from a 2D polygon, generated by InvoluteGear(), here, we're using that polygon, but then we're using PadArray() to make the points 3D, CurveOffsetLeft() to shrink the polygon, and ArrayAdd() to give them height, constructing a mes, which we 'skin' with CoverMesh(). Pretty chamfered 3D gears.
*/


include<TheGHOUL/Config.scad>

// Some settings.
Ratio=3;
Teeth=18;
Module=3;
Addendum=1.0;
Dedendum=1.25;
PressureAngle=20;
// Some math.
PitchRadius=Module*Teeth/2;
PitchAngle=Deg(Tau/Teeth);
Pitch=PitchRadius*Tau/Teeth;
BaseRadius=PitchRadius*cos(PressureAngle);
Teeth2=round(Teeth*Ratio);
PitchRadius2=Module*Teeth2/2;
PitchAngle2=Deg(Tau/Teeth2);
BaseRadius2=PitchRadius2*cos(PressureAngle);


// Generate a gear outline, copy and offset, generate polyhedron.
Q=PadArray(InvoluteGear(Module,Teeth2,Addendum,Dedendum,0,PressureAngle),3);
Q0=CurveOffsetLeft(Q,0.5,Closed=true);
Q1=ArrayAdd(Q,[0,0,0.5]);
Q2=ArrayAdd(Q,[0,0,10-0.5]);
Q3=ArrayAdd(Q0,[0,0,10]);
color(CPR)
translate([0,PitchRadius2,0])
rotate([0,0,-PitchAngle2*($t+0.5)])
CoverMesh([Q0,Q1,Q2,Q3],Endcaps=true,Convexity=30);

// Generate another gear outline, copy and offset, generate polyhedron.
P=PadArray(InvoluteGear(Module,Teeth,Addendum,Dedendum,0,,PressureAngle),3);
P0=CurveOffsetLeft(P,0.5,Closed=true);
P1=ArrayAdd(P,[0,0,0.5]);
P2=ArrayAdd(P,[0,0,10-0.5]);
P3=ArrayAdd(P0,[0,0,10]);
color(DSG)
translate([0,-PitchRadius,0])
rotate([0,0,PitchAngle*$t])
difference(){
    CoverMesh([P0,P1,P2,P3],Endcaps=true,Convexity=30);
    // Shaft hole.
    translate([0,0,-1])
    cylinder(r=5,h=12);
}

