/*
  This file belongs in

  <TheGHOUL/DemoFiles/>

  Hank J. van Leuvensteijn Jr. 2021
  theghoul@hankjr.ca

  Nothing that happens here merits explanation. Just read the documentation and comments in the actual routines and functions that are used here if something doesn't make sense or it's not clear to you what happens here.
*/
include<TheGHOUL/Config.scad>

//$t=0.5; // Troubleshooting.

SAnimSegs=10;

// Viewport animation
/*
$vpt=Animator([[0,[0,0,0]],[5,[-2,10,0]],[9,[-2,10,0]],[10,[0,0,0]]]);
$vpr=[30,0,50];
$vpd=Animator([[0,150],[5,50],[8,50],[10,150]]);
*/

VPT=[0,[1,12,0],[40,0,30],80];
$vpt=VPT[1];
$vpr=VPT[2];
$vpd=VPT[3];

/* Curve thickness. */
CR=0.2;

/* Some settings. */
Teeth=18;
Ratio=4;
Teeth2=round(Teeth*Ratio);
Module=3;
PressureAngle=20;
Addendum=1;
Dedendum=1.25;

/* Some math, we're making a pair, it would be nice if they mesh... */
PitchRadius=Module*Teeth/2;
PitchAngle=Deg(Tau/Teeth);
TipRadius=PitchRadius+Module*Addendum;
BaseRadius=PitchRadius*cos(PressureAngle);
PitchRadius2=Module*Teeth2/2;
PitchAngle2=Deg(Tau/Teeth2);
BaseRadius2=PitchRadius2*cos(PressureAngle);

/* The gears. =============================================================== */
translate([-PitchRadius,0,-0.55])
rotate([0,0,PitchAngle*$t])
InvoluteGear(Module,Teeth,Addendum,Dedendum,0,PressureAngle,0,"Pinion");

color(CPR)
translate([PitchRadius2,0,-0.55])
rotate([0,0,-PitchAngle2*(0.5+$t)])
InvoluteGear(Module,Teeth2,Addendum,Dedendum,0,PressureAngle);
