/* You gotta get The GHOUL. */
include<TheGHOUL/Config.scad>

SAnimSegs=10;

// Viewport animation
//$vpt=Animator([[0,[0,0,0]],[5,[-2,10,0]],[9,[-2,10,0]],[10,[0,0,0]]]); $vpr=[30,0,50]; $vpd=Animator([[0,150],[5,50],[8,50],[10,150]]);

// Comment this line out if you're using the animator above.
$vpt=[1,12,0]; $vpr=[40,0,30]; $vpd=80;

/* Curve thickness. */
CR=0.2;

/* Some parameters. */
Teeth=24;
Ratio=3;
Teeth2=Teeth*Ratio;
Module=3;
PressureAngle=20;
Addendum=1;
Dedendum=1.25;

//$t=0.5; // Troubleshooting -- comment this out for animation.

/* Some math. */
PitchRadius=Module*Teeth/2;
PitchAngle=Deg(Tau/Teeth);
TipRadius=PitchRadius+Module*Addendum;
BaseRadius=PitchRadius*cos(PressureAngle);
PitchRadius2=Module*Teeth2/2;
PitchAngle2=Deg(Tau/Teeth2);
BaseRadius2=PitchRadius2*cos(PressureAngle);

/* The gears. =============================================================== */
translate([-PitchRadius,0,0])
InvoluteGear(Module,Teeth,Addendum,Dedendum,0,PressureAngle,0,"Pinion");
color(CPR)
translate([PitchRadius2,0,0])
rotate([0,0,-PitchAngle2*-0.5])
InvoluteGear(Module,Teeth2,Addendum,Dedendum,0,PressureAngle,0);

/* Involute animation. ====================================================== */

/* Max Involute height of displayed curve in 'module units' */
MaxInvolute=1*Module+PitchRadius-BaseRadius;

// To achieve a movement that slows down and 'pauses' at it's maximum, we use a sinusoid curve, with Y=[0-100-0] for $t=[0-0.5-1].
Idex=ceil(1+(1-cos(360*$t))/2*99);
RR=BaseRadius+MaxInvolute*Idex/100; // Current point height (radius)

Involute2=AffineScale([1,-1,1],Involute(BaseRadius,RR));

AR=Sqrt(Pow2(RR)-Pow2(BaseRadius)); // 'Unwrapped cord' length (arc)
ANG=Deg(AR/BaseRadius); // 'Unwrapped angle'
translate([-PitchRadius,0,0.5])
rotate([0,0,-PitchAngle*0.25-InvoluteVertexAngle(BaseRadius,PitchRadius)]){
    // The involute
    color(RED)
    ShowCurve(Involute2,CR,1,$fn=6);
    // The 'unwrapping' cord.
    color(DSG){
        // 'Unwrapped length'
        BallCylinderBetween(
            // Cord endpoint describes the involute
            PadTuple(Last(Involute2)),
            // Point where cord is tangent to the base circle
            BaseRadius*[cos(ANG),sin(ANG),0],
            Radius=CR-Smidge,$fn=6
        );
        // Remaining cord (wrapped around the base circle)
        Arc(ANG,360-ANG,BaseRadius,2*CR-Smidge,FN=6,$fn=100);
    }
}

// The base circle
color(DSG,0.2)
translate([-PitchRadius,0,0.5])
cylinder(r=BaseRadius,h=1,center=true);
