/*
  This file belongs in

  <TheGHOUL/DemoFiles/>

  Hank J. van Leuvensteijn Jr. 2021
  theghoul@hankjr.ca

  Nothing that happens here merits explanation. Just read the documentation and comments in the actual routines and functions that are used here if something doesn't make sense or it's not clear to you what happens here.
*/
/*
  This file demonstrates profile shift for gears with ridiculously low teeth numbers. If you don't know what profile shift is, please GTS*.
*/
include<TheGHOUL/Config.scad>

// Pick-a-view
//VPT=[0,[1,6,0],[0,0,45],30];$vpt=VPT[1];$vpr=VPT[2];$vpd=VPT[3];
VPT=[0,[0,1,0],[0,0,40],50];$vpt=VPT[1];$vpr=VPT[2];$vpd=VPT[3];

//$t=0.5; // Troubleshooting.

ST=$t*3; // Animation speed increase.
SP=sin(180*$t); // Animation phase.

AD=1-0.2*SP; // Addendum
WD=2.25-0.2*SP; // Working depth
DD=WD-AD; // Dedendum
R=0.5; // Root radius
T=0.1; // Tip radius
PA=22.5; // Pressure angle
Z=5; // No. of teeth
M=3; // Module
RO=0; // Unbalanced rack ratio -- not yet implemented
SH=0.6*SP; // Profile shift
PCR=M*Z/2; // Pitch circle
BCR=PCR*cos(PA); // Base circle
RCR=PCR-M*DD; // Root circle
ACR=PCR-M*AD; // Addendum, i.e. tip circle
P=Pi*M; // Pitch
PAng=Deg(P/PCR); // PitchAngle

RIO=3; // Gear Ratio

// Naming as above
AD1=AD;
DD1=DD;
R1=0.1;
T1=0.1;
Z1=Z*RIO;
SH1=-SH;
PCR1=M*Z1/2;
BCR1=PCR1*cos(PA);
RCR1=PCR1-M*DD1;
ACR1=PCR1-M*AD1;

LT=0.1; // Line thickness of curves &c.

// Publish some salient data.
color(CPR){
    ScreenText(Text=str("AD=",SetDecimals(AD,1)),Location=[5.5,-4,0],Rotation=[0.02,0.02,0],Size=0.8,Color=DSG,_SizeCompensation=40);
    ScreenText(Text=str("WD=",SetDecimals(WD,1)),Location=[5.5,-5.2,0],Rotation=[0.02,0.02,0],Size=0.8,Color=DSG,_SizeCompensation=40);
    ScreenText(Text=str("SH=",SetDecimals(SH,1)),Location=[5.5,-6.4,0],Rotation=[0.02,0.02,0],Size=0.8,Color=DSG,_SizeCompensation=40);
}

// Pinion
color(DSG)
translate([-PCR,0,0.5+LT/2])
Circle(PCR,LT,$fa=3); // Pitch circle
color(GRN)
translate([-PCR,0,-0.25])
rotate([0,0,ST*PAng]) //
InvoluteGear(M,Z,AD,DD,SH,PA);
// Gear
color(DSG)
translate([PCR1,0,0.5+LT/2])
Circle(PCR1,LT,$fa=3); // Pitch circle
color(BLU)
translate([PCR1,0,0])
rotate([0,0,ST*PAng/-RIO]) //
rotate([0,0,180+PAng/2/RIO])
InvoluteGear(M,Z1,AD1,DD1,SH1,PA);
// Rack
translate([0,0,0]){
    color(YLW)
    translate([0,P*(6.5+ST),-0.5])
    rotate([0,0,180])
    /* Use DD also for AD to simulate 'double sided' cutter. */
    Rack(M,Z*5,DD,DD,-SH,PA,0,"",0.2,0.2,20);
    // Background simulates opposite rack
    color(MGT)
    translate([0,0,-1])
    circle(r=100);
}
/*
  *Google That Stuff. What did you think?.
*/
