/*
  This file belongs in

  <TheGHOUL/DemoFiles/>

  Hank J. van Leuvensteijn Jr. 2021
  theghoul@hankjr.ca
*/

include<TheGHOUL/Config.scad>

// Choose a good viewport.
$vpt=[2.6,2.5,0];
$vpr=[70,0,300];
$vpd=12;
$fn=100;

// Set some parameters.
Vector=[-1,2,1];
Alpha=0.3;
TextSize=0.25;
WordWobble=[20,20,0];
ArrowThickness=0.2;
// Figure stuff out.
Polar=VectorToPolar(Vector);
Radius=Polar.x;
Inclination=Polar.y;
Azimuth=Polar.z;

// The Vector. Hint makes it just a touch bigger than the shadow arrows (below) to avoid coincidental surfaces.
color(DSG)
Arrow(Vector,Thickness=ArrowThickness+Hint);
// The '0 angle' vector.
Arrow(Vector=[0,0,Radius],Thickness=ArrowThickness);

// Visualise the vector coordinates.
color(RED) // X
CylinderBetween([0,0,0],[Vector.x,0,0],0.02);
color(GRN) // Y
CylinderBetween([Vector.x,Vector.y,0],[Vector.x,0,0],0.02);
color(BLU) // Z
CylinderBetween([Vector.x,Vector.y,0],Vector,0.02);

// Display a coordinate system
translate([0,-2,0])
CoordinateSystem(Size=1,Thickness=0.1);

// Show the arc of the Inclination angle.
color(DSG)
translate([0,0,Vector.z])
ArrowArc(0,Azimuth,Modulus([Vector.x,Vector.y]),Thickness=0.04,Points=[0,0.15,1],Center=[0,0,0]);
// Show some 'shadow-arrows'.
color(SVR,Alpha)
    for(I=ArcAngles(0,Azimuth,$fn=15))
    rotate([0,Inclination,I])
    Arrow(Vector=[0,0,Radius],Thickness=ArrowThickness);

// Show the arc of the Azimuth angle.
color(OSG)
    rotate([-90,0,0])
    ArrowArc(-90,Inclination,Radius,Thickness=0.04,Points=[0,0.15,1],Center=[0,0,0]);
// Show some 'shadow-arrows'.
color(OSG,Alpha)
    for(I=ArcAngles(0,Inclination,$fn=15))
    rotate([0,I,0])
    Arrow(Vector=[0,0,Radius],Thickness=ArrowThickness);

// A few labels
color(DSG){
    VPRText("Azimuth",0.25,Thickness=0.05,Rotation=WordWobble,Location=[0,2.2,1.7],Spacing=0.9);

    VPRText("Inclination",0.25,Thickness=0.05,Rotation=WordWobble,Location=[0.5,0,2.8],Spacing=0.9);

    VPRText("[-1,2,1]",0.25,Halign="right",Thickness=0.05,Rotation=WordWobble,Location=[-1.2,2.2,1],Spacing=0.9);
}
