/* You gotta get The GHOUL. */
include<TheGHOUL/Config.scad>

// A bit of an animation showing some pertinent info on how involutes are made.
$t=0.5;
// Zero-angles cause warnings somewhere. Who needs zero anyway; the Romans did okay without...
Angle=2+88*$t;

// Pick a base radius.
r=12;

// The developed 'length', i.e., circle sector.
dev=PI*r*Angle/180;

// The 'pole', 'generator', or 'end of the line describing the curve'.
P=AffineRotate([0,0,1],[r,dev],-Angle);

// The base-circle.
color(DSG)
Circle(r,0.2);

// Current involute 'height',or 'tipradius' (also see involute-gear documentation).
/* HERE Warning raised 'unknown variable P' when Q is named R*/
Q=Modulus(P);

// the involute.
color(PRP)
Involute(12,Q);

// Some (helpful) lines.
*BallCylinderBetween([0,0],P);
color(CPR)
rotate([0,0,-Angle]){
BallCylinderBetween([0,0],[r,0]);
BallCylinderBetween([r,0],[r,dev]);}

