/*
  This file belongs in

  <TheGHOUL/DemoFiles/>

  Hank J. van Leuvensteijn Jr. 2021
  theghoul@hankjr.ca
*/

include<TheGHOUL/Config.scad>

$vpt=[ 2, 3, 8];
$vpr=[ 50, 0, 80];
$vpd=44;


Foo=[3,6,12];
Bar=LengthVector(Foo,5);
Baz=VectorToIncAz(Foo).z;
echo(Baz);
Boz=LengthVector(Baz,5);

Print(["FBB ",Foo,Bar,Boz],true,0);

color(BLU)
Arrow(Foo,Base=[0,0,0],Points=[0,2],Thickness=0.4);
color(RED)
Arrow(Bar,Base=[0,0,0],Points=[0,2],Thickness=0.42);
color(GRN)
Arrow(Boz,Base=[0,0,0],Points=[0,2],Thickness=0.42);

rotate([0,0,-90+Baz])
translate([-12,0,0])
circle(r=12);

color(DSG,0.3)
rotate([])
linear_extrude(Thought)
Sector(0,Baz,2);

color(DSG,0.5)
polyhedron([[0,0,0],[3,6,0],[3,6,12]],[[0,1,2]]);

Dimension([0,0,0],Boz,Type="A",Text="",TSize=1,Gap=0.5,TMove=[0,0,0],Decimals=2,Spacing=2,Extension=0.5,Direction="R",Location="B",Thickness=0.07,Marks="A",MSize=0.6,TSpacing=1,Outside=false);

Dimension([0,0,0],Foo,Type="A",Text="",TSize=1,Gap=0.5,TMove=[0,0,0],Decimals=2,Spacing=4,Extension=0.5,Direction="R",Location="A",Thickness=0.07,Marks="A",MSize=0.6,TSpacing=1,Outside=false);

Dimension([0,0,0],Bar,Type="A",Text="",TSize=1,Gap=0.5,TMove=[0,0,0],Decimals=2,Spacing=2,Extension=0.5,Direction="R",Location="A",Thickness=0.07,Marks="A",MSize=0.6,TSpacing=1,Outside=false);
