include<TheGHOUL/Config.scad>

$vpt=[4,2,0.5];
$vpr=[110,0,50];
$vpd=10;

color(GRN)
difference(convexity=10){
    NoCropThread(TriangularThread,10,Length=undef,External=false,Turns=1,Pitch=1.5,Lead=undef,ThreadAngle=undef,Height=undef,TaperAngle=30,LeftHanded=false,MultiStart=1,HigbeeIn=30,HigbeeOut=0,Higbee2D=false,HigbeeSkew=0,RootClearance=undef,Clearance=0,FlankContact=0,Interrupted=[0,0,0],ConversionFactor=1,Support=false,FN=12,_Quiet=false,ItemReference="");
    cylinder(r=10,h=10);
}

color(RED)
translate([Thought,Thought,Thought])
difference(convexity=10){
    NoCropThread(TriangularThread,10,Length=undef,External=false,Turns=1,Pitch=1.5,Lead=undef,ThreadAngle=undef,Height=undef,TaperAngle=30,LeftHanded=false,MultiStart=1,HigbeeIn=30,HigbeeOut=0,Higbee2D=false,HigbeeSkew=0,RootClearance=undef,Clearance=0,FlankContact=0,Interrupted=[0,0,0],ConversionFactor=1,Support=false,FN=12,_Quiet=false,ItemReference="");
    translate([0,0,-1])
    cylinder(r=10,h=1);
}

ScreenText(Text="'Tis but a slither...",Location=[2.5,-4,0],Rotation=[10,5,0],Size=1,Color=DSG,_SizeCompensation=60);

/* What follows is a de-commented version of 'Thread()', minus the crop feature of taper-induced-descending-vertices, for demo purposes. It's not completely deflated, but it shows that 'Thread()' is basically a bit less than 50 lines of code, I imagine you're happy 'Thread()' is commented, and not a mess like this ;-) */
module NoCropThread(ThreadType,NominalDiameter,Length=undef,External=true,Turns=undef,Pitch=undef,Lead=undef,ThreadAngle=undef,Height=undef,TaperAngle=undef,LeftHanded=false,MultiStart=1,HigbeeIn=30,HigbeeOut=0,Higbee2D=false,HigbeeSkew=0,RootClearance=undef,Clearance=0,FlankContact=0,Interrupted=[0,0,0],ConversionFactor=1,Support=false,FN=12,_Quiet=false,ItemReference=""){
    ThreadData=ThreadData(ThreadType,NominalDiameter,Pitch,ThreadAngle,Height,TaperAngle,Clearance,RootClearance,ConversionFactor,$fn=FN);
    if(undef==Turns&&undef==Length)Stop(["Either 'Turns' or 'Length' *must* be defined."]);
    if(undef==ThreadData[3])Stop(["The lookup table does not have an entry for Nominal Diameter ",NominalDiameter,", you must add it in TheGHOUL/Lib/Parts/ThreadData.scad."]);
    Alert(["ConversionFactor is set to ",ConversionFactor,"."],!_Quiet&&ConversionFactor!=1);
    _PitchRadius=ThreadData[5]/2;
    _Pitch=ThreadData[3];
    __Lead=Lead==undef?_Pitch:Lead>_Pitch?Lead:_Pitch;
    _Lead=__Lead*MultiStart;
    _Height=ThreadData[4];
    _FlankAngle=ThreadData[10]/2;
    _TaperAngle=ThreadData[11]/2;
    _ThreadAllowance=ThreadData[12];
    _Turns=Turns!=undef?MRound(Turns,1/$fn):MRound((Length-_Pitch)/_Lead,1/$fn);
    __Profile=PadArray(External?ThreadData[0]:ThreadData[1]);
    _Profile=LeftHanded?ReverseArray(__Profile):__Profile;
    Steps=_Turns*$fn;
    _Handedness=LeftHanded?-1:1;
    _ClearanceContactCorrection=FlankContact==0?0:FlankContact>0?Clearance/cos(_FlankAngle-_TaperAngle)/_Lead*360*_Handedness:-Clearance/cos(_FlankAngle+_TaperAngle)/_Lead*360*_Handedness;
    R1=_PitchRadius+(External?ThreadData[0][len(ThreadData[0])-2].x-ThreadData[7]*(1/cos(_TaperAngle)-1):ThreadData[1][1].x+ThreadData[6]*(1/cos(_TaperAngle)-1));
    H= _Lead*_Turns+_Pitch;
    R2= R1-sin(_TaperAngle)*H/cos(_TaperAngle);
    SupSurf=str(External==true?"External ":"Internal ","thread support surface",ItemReference==""?": ":str(" for ",ItemReference,": "),_TaperAngle==0?"cylinder(r=":"cylinder(r1=",R1,_TaperAngle==0?"":" ,r2=",_TaperAngle==0?"":R2,", h=",H,"); ");
    Overlap=FrogsHair;
    if(Support&&!External){difference(){
            cylinder(r1=R1-Overlap,r2=R2-Overlap,h=H);
            Thread(ThreadType,NominalDiameter,Length,External,_Turns,Pitch,Lead,ThreadAngle,Height,TaperAngle,LeftHanded,MultiStart,HigbeeIn,HigbeeOut,Higbee2D,HigbeeSkew,RootClearance,Clearance,FlankContact,Interrupted,ConversionFactor,Support=false,_Quiet=true,ItemReference=ItemReference);}
    }else if(Support){union(){
            cylinder(r1=R1+Overlap,r2=R2+Overlap,h=H);
            Thread(ThreadType,NominalDiameter,Length,External,Turns,Pitch,Lead,ThreadAngle,Height,TaperAngle,LeftHanded,MultiStart,HigbeeIn,HigbeeOut,Higbee2D,HigbeeSkew,RootClearance,Clearance,FlankContact,Interrupted,ConversionFactor,Support=false,_Quiet=true,ItemReference=ItemReference);}
    }else{Echo(0==_ThreadAllowance?["ATTENTION: Production allowance is 0"]:["Production allowance = ", _ThreadAllowance]);
        Echo([SupSurf]);
        StartHigbee=External ? HigbeeOut : HigbeeIn;
        EndHigbee=  External ? HigbeeIn  : HigbeeOut;
        InSlop=(_Turns*360-HigbeeIn-HigbeeOut)%(Interrupted[0]+Interrupted[1]);
        ProfileArray=[for (Jdex=[0:Steps])
            let(Here=Jdex/Steps,
                Done=Here*_Turns*360,
                ToDo=(1-Here)*_Turns*360,
                Skew=Here>0.5?HigbeeSkew:-HigbeeSkew,
                InLoc=(Done-StartHigbee-InSlop/2)%(Interrupted[0]+Interrupted[1]),
                EndRange=ToDo<(EndHigbee+InSlop/2)?true:false,
                Higbee=min(StartHigbee>0?Done/StartHigbee:1,EndHigbee>0?ToDo/EndHigbee:1),
                IntHigbee=!EndRange&&ArrayProduct(Interrupted)>0?max(0,(InLoc-Interrupted[0]/2-Interrupted[1]+Interrupted[2])/Interrupted[2],-(InLoc-Interrupted[0]/2-Interrupted[2])/Interrupted[2]):1,
                HigbeeFactor=min(1,Higbee,IntHigbee),
                Second=_Profile[1],
                LastButOne=_Profile[len(_Profile)-2],
                Attenuator=0.3,
                _HProfile=AffineTransform(TransformMatrix([[-((Second+LastButOne)/2).x,0,0,"T"],[[1,-(Second-LastButOne).x/(Second-LastButOne).y,0],[0,1,0],[0,0,1],"SH"],[0,-Second.y*Skew,0,"T"],[HigbeeFactor,Higbee2D?(HigbeeFactor+Attenuator)/(1+Attenuator):1,1,"S"],[0,Second.y*Skew,0,"T"],[[1,(Second-LastButOne).x/(Second-LastButOne).y,0],[0,1,0],[0,0,1],"SH"],[((Second+LastButOne)/2).x,0,0,"T"]]),_Profile),
                HProfile=[_Profile[0],_Profile[1],for(Hdex=[2:len(_HProfile)-3])_HProfile[Hdex],_Profile[len(_Profile)-2],_Profile[len(_Profile)-1]],
                Profile=AffineTransform(TransformMatrix([[90,0,0,"R"],[_PitchRadius-(_Lead*Jdex/$fn*tan(_TaperAngle)),0,_Pitch/2+_Lead*Jdex/$fn,"T"],[0,0,360*Jdex/$fn*_Handedness,"R"]]),HProfile))
        Profile];
        for (Idex=[0:MultiStart-1])
            rotate([0,0,Idex/MultiStart*360])
            rotate([0,0,_ClearanceContactCorrection*_Handedness*(External?1:-1)
            ])
            CoverMesh(ProfileArray,Endcaps=true);
    }
}
