/*
  This file belongs in

  <TheGHOUL/DemoFiles/>

  Hank J. van Leuvensteijn Jr. 2021
  theghoul@hankjr.ca
*/

include<TheGHOUL/Config.scad>

/* OPEN THE ANIMATION VIEW WITH STEPS=100 AND FPS=10. */

CPS=[[5,1,0],[1,8,0],[28,6,0],[-8,10,0],[3,16,0]];
// Offset dimension (ANIMATED)
Dist=0.5+2.5*sin($t*180);
// Spheres radius
R=0.1;
// Create a set of curve points
Array=BezierCurve(CPS,Resolution=20);
// Create offset sets of points
Brray=CurveOffsetRight(Array,Dist,false);
// Begin and End points for vectors
Crray=CurveOffsetRight(Array,R,false);
Drray=CurveOffsetRight(Array,Dist-R,false);

// Display offset curve
color(Intermediate(DOG,DGN,sin($t*180)))
translate([4,0,0])
ShowCurve(Brray,0.1,Frac=1,Connect=true,Closed=false);

// Original curve points
color(DOG)
for(U=Array)
translate(U)
sphere(r=R);
// Offset curve points
color(DGN)
for(V=Brray)
translate(V)
sphere(r=R);
// Offset vectors
for(I=[0:Len(Array)])
color(OSG,0.2+0.8*cos($t))
Arrow(Drray[I]-Crray[I],Points=[0,0.4,1],Thickness=0.1,Base=Crray[I]);
