/*
  This file belongs in

  <TheGHOUL/DemoFiles/>

  Hank J. van Leuvensteijn Jr. 2021
  theghoul@hankjr.ca
*/

include<TheGHOUL/Config.scad>


Rows=5; // Rows of Pascal's triangle

X=20; // dimension of the tiles
Y=20; // dimension of the tiles

for(Idex=[0:Rows-1])
    {
        for(Jdex=[0:Idex])
            {
                translate([-Idex/2*X+Jdex*X,-Idex*Y,0])
                    {
                        // tile
                        ChamferedCube(X,Y,min(X,Y)/5+1,min(X,Y)/10);
                        // text
                        translate([-X/5,0,5])
                        rotate([15,15,0])
                        color(DSG)
                        SimpleText(str(BinomialCoefficient(Idex,Jdex)),10,Thickness=2,Center=true,Font="Roboto Slab",Spacing=0.5);
                    }
            }
    }


