/*
  This file belongs in

  <TheGHOUL/DemoFiles/>

  Hank J. van Leuvensteijn Jr. 2021
  theghoul@hankjr.ca
*/
//$t=0.05;

include<TheGHOUL/Config.scad>

// Set animation duration (Animate.scad).
$AnimSegs=10;
// Choose a nice viewpoint.
$vpt=[3,2,2];$vpr=[60,0,225+$t*180];$vpd=22;
// Show the coordinate system.
CoordinateSystem(Size=3,Thickness=0.1,Points=[0,0.2],Polar=false);
/* Text rotation. */
TROT=[5,5,0];

// Put some *stationary* info at the top of the screen.
ScreenText(Text="Position([1,2,0],Base=[3,2,2],Roll=180)",Size=0.6,Location=[0,6.5,5],Rotation=TROT,Color=("Silver"));

// Comment what we have on screen.
Animate(AnimVector=[0,0,0,1])
ScreenText(Text="Position Vector and Base.",Size=0.6,Location=[0,-6.5,5],Rotation=TROT,Color=DSG);

// Show during entire animation.
Animate(AnimVector=[0,0,0,10])
translate([3,2,2])
color("red")
sphere(r=0.2);

// Show during entire animation.
Animate(AnimVector=[0,0,1,10])
Arrow([2.5,5,0],Base=[3,2,2]*$AnFrac,Points=[0,0.25,1],Thickness=0.2);

// Show from 1 to 3 seconds.
Animate([1,1,3,3])
{
    color(DSG,$AnAlpha)
    rotate([0,-90,0])
    linear_extrude(1,scale=0)
    ArrowHead(2,4,1);
    // A comment at the bottom of the screen.
    ScreenText(Text="The Object.",Size=0.6,Location=[0,-6.5,5],Rotation=TROT,Color=DSG);
}

// Show from 3 to 5 seconds.
Animate([3,3,5,5])
{
    // '_A' decreases from 0 to -0.4. We add '$AnFrac' to get 'A', as '$AnFrac' increases, more of these values become >0. The '0+$AnFrac' value is drawn first; this is the 'leading shape' in the animation which is the darkest and more opaque.
    for(_A=[0:-0.2:-0.4]){
        A=_A+$AnFrac;
            if(A>0){
            color(DSG,A)
            // 'A' is a fraction, used as an exponent it provides a nice curve for 'much more better' effect. Function to 'approach' the final position.
            Position(Vector=[A,2*A*A,1-A*A],Base=[3*A,2*A,2*A],Roll=0)
            rotate([0,-90,0])
            linear_extrude(1,scale=0)
            ArrowHead(2,4,1);
        }
    }
    // A comment at the bottom of the screen.
    ScreenText(Text="Position...",Size=0.6,Location=[0,-6.5,5],Rotation=TROT,Color=DSG);
}

// Show from 5 to 7 seconds.
Animate([5,5,7,7]){
    // The leading shape is now in position 'A=1'. We keep increasing 'A'...
    for(_A=[1:-0.2:0.6]){
    // But we ignore values above '1'; as '$AnFrac' increases, more of these values are 'cropped out' and shapes 'disappear'.
        A=_A+$AnFrac;
        if(A<1){
            // Use '_A' for alpha as it -conveniently- already has the right value. (We like the KISS rule...)
            color(DSG,_A)
            // See comment at line 45.
            Position(Vector=[A,2*A*A,1-A*A],Base=[3*A,2*A,2*A],Roll=0)
            rotate([0,-90,0])
            linear_extrude(1,scale=0)
            ArrowHead(2,4,1);
        }
    }
    // A stationary object at the final position.
    color(DSG)
    Position(Vector=[1,2,0],Base=[3,2,2],Roll=0)
    rotate([0,-90,0])
    linear_extrude(1,scale=0)
    ArrowHead(2,4,1);
    // Info at the bottom of the screen.
    ScreenText(Text="Position...",Size=0.6,Location=[0,-6.5,5],Rotation=TROT,Color=DSG);
}

Animate([7,7,9,10])
{
    color(DSG)
    // Pretty straight-forward move here.
    Position(Vector=[1,2,0],Base=[3,2,2],Roll=180*$AnFrac)
    rotate([0,-90,0])
    linear_extrude(1,scale=0)
    ArrowHead(2,4,1);
    ScreenText(Text="and Roll.",Size=0.6,Location=[0,-6.5,5],Rotation=TROT,Color=DSG);
    // An arcing arrow to indicate the roll.

    Position(Vector=[1,2,0],Base=[3,2,2],Roll=90)
    ArrowArc(StartAngle=0,Angle=180,Radius=2,Thickness=0.2,Points=[0,1]);

}
