/*
  This file belongs in

  <TheGHOUL/DemoFiles/>

  Hank J. van Leuvensteijn Jr. 2021
  theghoul@hankjr.ca
*/

include<TheGHOUL/Config.scad>

    Crv=[[1,0,0],[3,0,0],[6,3,0],[6,5,0]];

    Crv1=AffineTransform(TransformMatrix([[0,3,3,"T"],[0,-30,0,"R"]]),Crv);
    Crv2=AffineTransform(TransformMatrix([[0,3,6,"T"],[0,-30,0,"R"]]),Crv);

    color(GRN)
    ShowCurve(Crv1,0.1,Connect=false);
    color(GRN)
    ShowCurve(Crv2,0.1,Connect=false);

    ShowCurve(Crv1,0.04,Connect=true);
    ShowCurve(Crv2,0.04,Connect=true);

    Cyls1=[
        [Crv1[1],Crv1[2]],
        [Crv1[2],Crv2[2]]
    ];

    Cyls2=[
        [Crv2[2],Crv2[1]],
        [Crv2[1],Crv1[1]]
    ];

    color(RED)
    for(Cyl=Cyls1)CylinderBetween(Cyl.x,Cyl.y,Radius=0.05);
    color(BLU)
    for(Cyl=Cyls2)CylinderBetween(Cyl.x,Cyl.y,Radius=0.05);

    D=UnitVector(Crv1[1]-Crv2[1])*0.05;

    translate(D)
    color(RED)
    CylinderBetween(Crv1[1],Crv2[2],Radius=0.05);
    translate(-D)
    color(BLU)
    CylinderBetween(Crv1[1],Crv2[2],Radius=0.05);
