include<TheGHOUL/Config.scad>

$vpt=[0,0,0];$vpr=[55,0,30];$vpd=36;
$AnimSegs=10;
$t=0.3;
// For this one, set $fn to the animation 'Steps' number or the curve and 'writer' will not coincide in each frame.
$fn=50;
//Trochoids();
module Trochoids(){
    // Frequency, or period... Number of different images during entire animation.
    P=5;

    // 'Lifted' sine-curve, clipped to 1, at frequency 'P'. Used to fade images out-and-in at change-over point.
    function Alp(T=$t,F=P,f=1)=
        let(
            A=min(sin(-90+((T*F)%1)*360)*f+f,1),
            B=Print(["A ",A])
        )
        A
    ;
    // triangle
    Animate([0,0,2,2])
    ShowTrochoid(6,-2,1.0,$fn=100,$t=(P*$t)%1,Alpha=Alp($t));
    // nephrdioid
    Animate([2,2,4,4])
    ShowTrochoid(6,3,3,$fn=100,$t=(P*$t)%1,Alpha=Alp($t));

    Animate([4,4,6,6])
    ShowTrochoid(6,1,2,$fn=100,$t=(P*$t)%1,Alpha=Alp($t));
    // astroid
    Animate([6,6,8,8])
    ShowTrochoid(6,-1.5,1.5,$fn=100,$t=(P*$t)%1,Alpha=Alp($t));

    Animate([8,8,10,10])
    ShowTrochoid(6,-2,3,$fn=100,$t=(P*$t)%1,Alpha=Alp($t));

    // tusi couple
    //ShowTrochoid(6,-3,3,$fn=100,$t=(P*$t)%1,Alpha=Alp($t));
}

//Invol();
module Invol(R=6){
    ShowCurve(Involute(R),0.2);
    color(DSG)
    ShowCurve(Circle(R),0.2,Frac=1,Connect=true,Closed=true);
}
