/*
  This file belongs in

  <TheGHOUL/DemoFiles/>

  Hank J. van Leuvensteijn Jr. 2021
  theghoul@hankjr.ca
*/

include<TheGHOUL/Config.scad>

//Ampersand
$vpt=[0,0,0];$vpr=[0,0,0];$vpd=2800;Tumble([720,1080,360])translate([-400,-400,0]){linear_extrude(50,twist=5)SVG("M341 426q27 14 53.5 27.5t48 31 34.5 41t13 58.5q0 32 -13.5 56.5t-33 41.5t-41.5 26t-40 9q-35 0 -62.5 -13t-47 -34.5t-29.5 -50.5t-10 -62q-1 -35 7.5 -69t17.5 -66q-49 -23 -84.5 -47t-58.5 -51.5t-34 -60t-11 -72.5q0 -56 21 -103t56.5 -81t81 -53t95.5 -19 q42 0 83 15.5t89 49.5q43 -35 79 -50t68 -15q43 0 75 18t52 45t28.5 59.5t4.5 61.5h-24q-6 -38 -20.5 -63t-32 -39t-36 -19.5t-33.5 -5.5q-26 0 -48.5 14.5t-51.5 49.5l19 24q21 26 34 44t24.5 30t25 19.5t36.5 12.5q-11 18 -16 30t-8 22.5t-4 21t-2 26.5 q-16 -9 -26.5 -14.5t-20.5 -9t-21 -5.5t-27 -4q15 -44 6 -80t-45 -80q-20 29 -27.5 41.5t-9.5 16.5zM423 593q0 -40 -24 -69t-72 -58q-5 12 -11.5 28.5t-12 35.5t-9.5 38.5t-4 36.5q0 38 21 56t47 17q11 -1 22.5 -6.5t21 -16t15.5 -26t6 -36.5zM150 190q0 26 5.5 53.5 t17.5 52.5t32.5 47t50.5 37l100 -201q16 -30 26.5 -48.5t19.5 -32.5t19 -29t26 -38q-61 -47 -125 -47q-34 0 -65 14t-55 41t-38 65t-14 86z",false,$Verbose=false);rotate([0,0,-5])translate([0,0,50])linear_extrude(50,twist=-5)SVG("M341 426q27 14 53.5 27.5t48 31t34.5 41t13 58.5q0 32 -13.5 56.5t-33 41.5t-41.5 26t-40 9q-35 0 -62.5 -13t-47 -34.5t-29.5 -50.5t-10 -62q-1 -35 7.5 -69t17.5 -66q-49 -23 -84.5 -47t-58.5 -51.5t-34 -60t-11 -72.5q0 -56 21 -103t56.5 -81t81 -53t95.5 -19 q42 0 83 15.5t89 49.5q43 -35 79 -50t68 -15q43 0 75 18t52 45t28.5 59.5t4.5 61.5h-24q-6 -38 -20.5 -63t-32 -39t-36 -19.5t-33.5 -5.5q-26 0 -48.5 14.5t-51.5 49.5l19 24q21 26 34 44t24.5 30t25 19.5t36.5 12.5q-11 18 -16 30t-8 22.5t-4 21t-2 26.5 q-16 -9 -26.5 -14.5t-20.5 -9t-21 -5.5t-27 -4q15 -44 6 -80t-45 -80q-20 29 -27.5 41.5t-9.5 16.5zM423 593q0 -40 -24 -69t-72 -58q-5 12 -11.5 28.5t-12 35.5t-9.5 38.5t-4 36.5q0 38 21 56t47 17q11 -1 22.5 -6.5t21 -16t15.5 -26t6 -36.5zM150 190q0 26 5.5 53.5 t17.5 52.5t32.5 47t50.5 37l100 -201q16 -30 26.5 -48.5t19.5 -32.5t19 -29t26 -38q-61 -47 -125 -47q-34 0 -65 14t-55 41t-38 65t-14 86z",false,$Verbose=false);}

//Aeroplane cartoon
//linear_extrude(200)SVG("M2393 2318 c-67 -70 -122 -225 -123 -345 0 -47 -3 -53 -32 -71 -41 -24 -146 -49 -263 -62 -127 -14 -368 -13 -383 2 -13 13 -42 -6 -42 -28 0 -7 -7 -32 -16 -54 -20 -50 -67 -80 -124 -80 -37 0 -48 5 -81 40 -28 29 -39 51 -45 86 -6 43 -8 45 -33 39 -79 -19 -131 -17 -221 9 -155 44 -294 31 -415 -39 -24 -15 -56 -40 -70 -57 -14 -17 -27 -29 -29 -27 -2 2 -11 25 -20 50 -17 44 -58 99 -75 99 -13 0 -56 -54 -73 -91 -9 -20 -22 -82 -28 -137 -23 -196 29 -412 100 -412 20 0 55 37 65 68 9 30 17 28 53 -17 65 -81 239 -171 332 -171 58 0 115 -65 76 -87 -24 -13 -46 -65 -46 -107 0 -78 60 -136 142 -136 88 0 145 68 135 160 -4 38 -12 52 -52 87 -40 37 -45 45 -35 63 6 11 14 20 19 20 5 0 34 -29 65 -64 60 -69 175 -160 241 -190 22 -10 70 -21 108 -24 61 -4 71 -2 106 22 56 39 76 91 76 201 0 49 -2 108 -5 130 l-5 40 55 6 c88 9 238 86 397 201 29 21 56 38 62 38 5 0 14 -13 19 -30 21 -59 100 -65 131 -9 20 36 7 75 -31 95 l-31 16 39 36 c21 19 53 49 71 65 l32 30 73 -78 c40 -43 88 -84 106 -92 31 -13 36 -12 54 3 25 24 20 43 -49 181 l-57 112 -8 183 c-8 198 -27 289 -69 334 -31 33 -59 30 -96 -8z",false,$Verbose=false);

//Aeroplane biplane
//linear_extrude(200)SVG("M11485 11025 c-33 -14 -80 -39 -105 -57 -25 -17 -70 -48 -100 -69 -106 -70 -392 -315 -777 -664 -60 -55 -186 -166 -280 -247 -93 -81 -214 -189 -269 -240 -115 -109 -318 -292 -473 -428 -59 -52 -149 -132 -198 -176 -49 -45 -110 -93 -134 -107 -25 -15 -71 -56 -102 -91 -31 -35 -119 -117 -194 -182 -76 -65 -197 -173 -269 -239 -71 -67 -170 -150 -220 -185 -126 -90 -215 -166 -588 -500 -182 -162 -359 -321 -395 -353 -683 -598 -1066 -947 -1091 -996 -10 -20 -47 -64 -82 -97 -75 -73 -352 -305 -458 -383 -41 -30 -109 -83 -150 -116 -41 -34 -104 -83 -140 -108 l-64 -47 -108 0 c-124 0 -156 -9 -302 -82 -116 -58 -382 -235 -511 -340 -49 -40 -120 -93 -156 -118 -37 -25 -111 -83 -165 -130 -55 -47 -112 -94 -129 -105 -16 -10 -77 -60 -135 -111 -140 -124 -319 -263 -349 -271 -30 -7 -88 22 -110 57 -18 28 -35 42 -106 85 -27 17 -76 51 -107 77 -31 25 -66 49 -77 53 -12 3 -21 10 -21 14 0 14 -107 84 -270 176 -85 49 -195 115 -245 148 -49 33 -155 91 -235 129 l-145 70 -95 -1 c-105 -1 -168 -7 -217 -23 -32 -9 -33 -11 -33 -70 0 -122 70 -302 186 -478 34 -52 78 -127 98 -165 19 -39 44 -80 57 -90 23 -21 99 -129 99 -141 0 -7 60 -90 151 -207 31 -40 98 -119 150 -177 115 -128 135 -156 119 -175 -6 -7 -82 -62 -168 -121 -86 -60 -195 -136 -242 -170 -47 -34 -105 -71 -130 -84 -25 -12 -63 -40 -85 -61 -145 -141 -511 -429 -780 -614 -55 -38 -129 -92 -166 -121 -103 -82 -199 -143 -236 -150 -21 -4 -42 -18 -56 -36 -12 -16 -35 -43 -52 -59 -48 -48 -425 -336 -563 -431 -123 -85 -272 -211 -261 -222 6 -6 115 27 234 72 159 60 605 269 815 382 41 23 117 62 167 88 l92 46 30 -28 c16 -15 37 -46 47 -69 10 -23 39 -80 65 -127 25 -47 59 -114 74 -150 15 -36 54 -103 85 -150 31 -47 78 -133 105 -190 27 -58 58 -121 70 -140 12 -19 63 -116 114 -215 51 -99 105 -196 120 -215 33 -44 111 -199 111 -222 0 -11 -60 -60 -162 -132 -90 -63 -192 -136 -228 -162 -36 -27 -139 -100 -229 -162 -91 -63 -183 -129 -205 -146 -23 -18 -109 -78 -191 -134 -83 -55 -159 -110 -170 -123 l-20 -22 42 6 c87 14 394 149 803 353 234 117 472 243 530 280 58 37 146 86 196 109 59 28 99 54 115 75 42 55 71 80 184 158 61 42 160 112 220 157 61 45 184 132 275 195 91 63 200 140 242 171 94 70 193 127 253 144 66 20 80 30 119 84 28 40 71 74 203 160 92 61 191 127 218 148 112 85 380 275 530 377 140 96 297 205 540 380 39 27 183 129 320 225 138 96 270 191 295 212 25 20 92 68 150 105 58 37 137 91 175 119 168 124 296 205 324 205 24 0 33 -10 78 -93 98 -178 223 -437 223 -462 0 -24 -3 -25 -57 -25 -95 0 -152 -53 -169 -158 -27 -167 185 -496 383 -594 85 -42 144 -46 203 -16 38 20 50 34 79 93 27 56 33 81 32 127 -1 31 -6 70 -13 85 -6 15 -12 74 -13 130 l-3 102 82 65 c45 35 136 104 202 152 146 106 439 331 514 394 91 77 172 135 235 171 56 31 66 34 150 34 l90 0 70 -47 c69 -47 71 -48 150 -48 94 0 112 9 151 76 l26 45 -20 102 c-11 56 -24 120 -27 142 -10 58 -81 189 -136 250 -93 101 -236 174 -343 175 -45 0 -53 -4 -91 -44 -43 -44 -55 -77 -55 -147 0 -21 -5 -41 -10 -44 -12 -8 -90 48 -143 103 l-38 39 75 68 c126 112 176 204 195 354 l10 75 -65 121 c-35 67 -64 129 -64 138 0 8 18 28 39 44 21 15 61 44 87 63 27 19 87 71 134 116 93 88 423 374 498 431 26 19 99 79 162 133 235 201 468 398 555 470 50 41 149 128 220 194 72 65 155 137 185 159 62 46 165 135 287 247 113 104 159 138 317 231 45 27 66 48 82 78 11 23 43 65 70 93 45 46 479 425 678 591 44 38 118 101 164 140 281 243 290 250 342 261 34 7 106 70 114 98 3 13 74 91 157 173 84 83 178 183 210 223 76 94 129 205 136 281 5 53 3 60 -23 90 -40 44 -94 51 -155 21 -64 -33 -162 -101 -259 -180 -47 -39 -130 -104 -185 -147 -55 -42 -149 -120 -210 -174 -188 -164 -269 -229 -285 -227 -8 2 -26 23 -39 48 -13 25 -51 92 -84 150 -33 58 -76 134 -95 170 -19 36 -48 81 -64 102 -15 20 -40 63 -55 95 -15 32 -34 69 -43 83 -10 14 -49 79 -87 145 -105 182 -225 380 -264 437 -48 70 -119 209 -119 233 0 32 7 39 235 231 374 313 497 442 582 611 29 58 37 88 41 146 10 155 -57 202 -203 142 m-721 -1221 c9 -3 16 -12 16 -20 0 -7 18 -39 40 -70 21 -31 44 -72 51 -93 6 -20 26 -61 44 -91 17 -30 51 -90 74 -133 23 -43 62 -109 87 -147 24 -38 44 -73 44 -78 0 -5 16 -33 36 -62 20 -29 42 -68 50 -86 8 -18 32 -61 54 -95 22 -34 40 -66 40 -71 0 -5 11 -24 25 -42 14 -18 25 -35 25 -38 0 -3 18 -32 39 -64 21 -33 63 -104 92 -159 29 -55 65 -116 81 -136 15 -20 28 -46 28 -57 0 -34 -207 -209 -235 -199 -8 4 -21 22 -29 41 -8 20 -36 68 -62 108 -26 40 -78 130 -116 201 -37 70 -87 157 -111 195 -58 90 -142 228 -202 332 -106 185 -209 367 -228 405 -11 22 -24 47 -29 55 -41 73 -58 121 -49 138 18 33 134 134 176 153 47 22 40 20 59 13 m-280 -339 c22 -39 67 -117 101 -175 34 -58 89 -161 123 -230 33 -69 87 -165 118 -215 31 -49 71 -117 89 -150 49 -92 72 -131 144 -245 37 -58 78 -122 90 -143 13 -21 43 -61 67 -89 36 -42 44 -59 44 -90 0 -76 -22 -99 -400 -429 -237 -207 -348 -302 -599 -514 -65 -55 -159 -137 -207 -181 -241 -220 -368 -328 -657 -558 -203 -162 -204 -163 -222 -145 -8 8 -46 71 -84 139 -116 212 -242 434 -261 460 -10 14 -33 57 -52 95 -84 168 -309 585 -365 677 l-35 57 19 33 c10 18 59 64 108 103 49 38 123 102 165 141 94 88 272 243 410 357 58 47 152 129 210 182 120 108 333 298 560 496 85 75 209 187 275 250 138 130 241 221 270 237 34 20 48 9 89 -63 m-2162 -1862 c34 -36 75 -106 161 -273 38 -74 78 -147 88 -162 11 -14 19 -32 19 -40 1 -22 38 -98 78 -157 21 -31 71 -117 112 -191 40 -74 106 -191 145 -260 40 -69 95 -169 121 -222 l48 -97 -24 -26 c-27 -29 -223 -165 -238 -165 -5 0 -64 98 -132 218 -67 119 -151 265 -185 323 -35 58 -89 156 -120 219 -31 62 -80 154 -108 204 -28 50 -64 118 -80 151 -16 33 -51 98 -77 145 -27 47 -56 109 -66 138 l-17 53 44 45 c56 57 155 124 183 124 12 0 34 -12 48 -27 m-354 -290 c11 -16 63 -111 116 -212 54 -102 105 -196 115 -210 10 -14 27 -46 38 -71 11 -25 78 -153 150 -285 72 -132 154 -287 183 -345 29 -58 67 -123 85 -145 35 -44 75 -116 75 -138 0 -15 -49 -64 -146 -144 -39 -32 -102 -85 -141 -118 -96 -83 -269 -218 -294 -230 -18 -7 -27 -3 -53 26 -226 254 -219 250 -388 256 -77 3 -159 -1 -236 -11 -64 -9 -202 -25 -307 -36 -220 -22 -202 -28 -258 80 -19 36 -57 106 -86 155 -28 50 -60 115 -72 145 -11 30 -36 81 -56 113 -32 53 -34 61 -22 83 21 40 255 263 384 366 66 52 172 144 235 204 63 60 178 163 255 229 77 66 174 152 215 191 83 79 146 124 172 124 9 0 25 -12 36 -27 m-1270 -1420 c71 -127 139 -245 152 -262 27 -39 22 -53 -28 -86 -30 -20 -60 -28 -118 -34 -48 -5 -98 -18 -127 -32 -35 -17 -52 -21 -64 -13 -15 9 -133 214 -175 304 -11 25 -32 68 -46 96 -14 28 -23 58 -19 66 3 9 44 44 92 79 48 35 107 81 133 101 37 30 49 35 59 25 7 -6 70 -116 141 -244 m-496 -80 c13 -16 31 -44 38 -63 7 -19 35 -71 61 -115 65 -109 87 -164 68 -176 -29 -18 -81 -8 -160 32 l-81 40 -39 84 c-21 45 -39 92 -39 103 0 25 44 78 85 103 38 24 37 24 67 -8 m-207 -242 c25 -47 43 -91 41 -98 -3 -6 -51 -37 -108 -68 -57 -31 -125 -70 -151 -86 -27 -16 -52 -29 -57 -29 -12 0 -69 93 -80 131 -13 44 -6 61 30 83 17 10 69 47 115 82 91 69 119 84 147 76 10 -2 38 -42 63 -91 m-428 -230 c33 -49 30 -68 -14 -80 -21 -6 -87 -31 -148 -56 -116 -47 -155 -54 -174 -31 -10 12 0 23 51 59 35 24 83 57 108 72 25 15 58 39 74 52 39 33 74 27 103 -16 m-3396 -53 c7 -13 38 -51 70 -85 32 -34 77 -95 100 -135 23 -40 113 -179 199 -308 237 -356 620 -962 620 -981 0 -13 -33 -11 -82 5 -24 8 -58 17 -75 21 -42 8 -73 47 -154 186 -35 61 -80 131 -100 158 -39 51 -135 204 -164 261 -10 18 -24 40 -31 48 -8 7 -14 17 -14 22 0 4 -19 32 -43 62 -43 53 -116 158 -171 246 -16 26 -69 108 -116 182 -48 74 -97 154 -109 177 -11 23 -41 67 -66 97 -51 63 -50 63 57 65 60 1 69 -1 79 -21 m2884 -248 c3 -5 -3 -18 -14 -29 -24 -24 -181 -105 -181 -94 1 13 164 133 181 133 4 0 10 -4 14 -10 m571 -185 c67 -20 104 -61 160 -179 26 -55 62 -120 81 -144 43 -56 103 -182 103 -215 0 -17 -8 -31 -22 -38 -34 -19 -127 -15 -172 6 -39 19 -80 71 -69 88 3 5 30 7 62 3 60 -7 121 7 121 28 0 20 -57 69 -117 101 -31 17 -64 41 -74 55 -18 24 -18 27 -2 71 16 44 16 48 0 73 -21 32 -61 43 -99 28 -95 -39 -89 -38 -104 -17 -23 31 -35 85 -23 107 11 20 62 47 90 48 8 0 38 -7 65 -15 m278 -45 c69 -109 181 -310 201 -362 13 -31 40 -84 61 -118 28 -46 34 -64 26 -72 -8 -8 -20 -9 -39 -2 -22 7 -39 30 -74 99 -65 128 -158 297 -174 315 -23 27 -85 151 -85 171 0 16 6 20 28 17 20 -2 35 -15 56 -48 m2259 -667 c76 -52 91 -68 83 -82 -7 -11 -26 -5 -189 52 -141 50 -132 46 -119 59 16 16 81 27 122 22 19 -3 66 -26 103 -51 m-405 -64 c86 -23 207 -61 267 -86 161 -66 176 -71 222 -83 23 -6 60 -26 83 -45 23 -19 47 -35 53 -35 7 0 19 -4 27 -10 22 -14 -3 -37 -185 -168 -208 -151 -532 -400 -615 -472 -71 -62 -229 -183 -262 -201 -13 -7 -24 -7 -30 -1 -10 10 -22 163 -38 512 -12 261 -12 395 -1 464 9 56 30 77 118 122 110 55 159 56 361 3 m-609 -161 c5 -13 12 -174 16 -358 7 -332 7 -335 -14 -354 -17 -16 -25 -17 -45 -8 -26 11 -51 55 -196 337 -51 99 -99 190 -107 202 -14 21 -13 25 19 53 39 37 262 150 296 150 14 0 26 -8 31 -22 m1701 -88 c0 -5 -4 -10 -10 -10 -5 0 -10 5 -10 10 0 6 5 10 10 10 6 0 10 -4 10 -10 m-5636 -155 c32 -9 87 -19 122 -24 38 -6 74 -18 93 -32 44 -32 143 -50 346 -59 99 -5 190 -12 201 -15 24 -5 45 -39 141 -235 80 -161 214 -409 293 -540 88 -148 103 -177 97 -193 -6 -15 -115 -95 -587 -429 -288 -204 -388 -278 -470 -346 -19 -16 -129 -94 -245 -174 -115 -80 -259 -180 -319 -222 -60 -42 -136 -93 -168 -112 l-59 -36 -30 28 c-29 27 -73 104 -187 324 -84 162 -95 182 -123 225 -14 22 -110 204 -212 404 -103 200 -203 384 -222 409 -52 67 -48 94 20 159 51 47 106 86 375 262 102 67 219 153 320 236 41 34 122 92 180 130 116 74 290 210 290 226 0 11 36 27 65 28 12 1 47 -6 79 -14 m2819 -54 c-58 -53 -199 -151 -338 -236 -64 -39 -189 -122 -277 -185 -269 -192 -342 -240 -364 -240 -33 0 -54 32 -165 245 -176 341 -182 353 -176 368 7 20 67 24 497 38 473 14 690 26 725 37 17 6 55 10 85 11 l55 0 -42 -38 m-1474 -79 c32 -34 271 -490 271 -517 0 -5 22 -45 50 -88 l50 -77 -38 -26 c-20 -13 -71 -47 -112 -75 -41 -28 -91 -61 -110 -75 l-35 -26 -33 38 c-30 35 -204 338 -264 459 -42 84 -42 99 -6 140 34 40 46 88 47 192 1 79 14 93 88 93 52 0 59 -3 92 -38 m-371 2 c13 -23 3 -54 -18 -54 -23 0 -46 50 -28 61 20 13 36 11 46 -7 m-2411 -873 c20 -22 146 -243 209 -366 22 -44 78 -147 123 -230 46 -82 131 -238 188 -345 58 -107 115 -213 127 -235 13 -22 34 -69 47 -105 14 -36 42 -89 62 -119 43 -62 45 -74 15 -103 -42 -38 -252 -180 -298 -201 l-44 -20 -29 34 c-16 19 -86 147 -156 284 -70 138 -150 291 -178 340 -107 192 -413 805 -413 828 0 35 22 57 140 138 58 40 120 83 139 96 41 28 45 28 68 4 m5494 -162 c-24 -20 -81 -26 -81 -9 0 10 92 41 100 33 3 -3 -6 -13 -19 -24");

//The almighty one...
//color(DGN)rotate([0,0,-30])translate([0,0,200])SVG("M344 48v221q36 -26 59.5 -52.5t23.5 -58.5q0 -36 -22.5 -66t-60.5 -44zM254 4q13 -2 20 -2h8h15q8 0 16 1v-58h31v63q35 8 64.5 24.5t50.5 40.5t32.5 54t11.5 65t-13.5 63.5t-35.5 52t-51 44t-59 38.5v267q23 -13 35.5 -31t12.5 -34q0 -25 -5 -45.5t-5 -38.5 q0 -30 17.5 -52.5t49.5 -22.5q9 0 14 1t9.5 3t10 5t14.5 8l-10 25q-3 0 -7 -0.5t-8 -0.5q-11 0 -13 11.5t-1 28.5t4 35t3 32q0 24 -9.5 44t-26 35t-38.5 25.5t-47 16.5v45h-31v-41q-7 1 -12.5 1.5t-11.5 0.5q-10 0 -18.5 -0.5t-16.5 -1.5v41h-32v-45q-68 -15 -104 -61.5 t-36 -121.5q0 -26 11.5 -49.5t31 -44.5t44.5 -41t53 -38v-289q-32 18 -52.5 44t-20.5 46q-1 17 4 30t20 36q-8 3 -16.5 7t-18 10.5t-22 16t-29.5 23.5q-5 -14 -8 -23t-7 -18t-11.5 -21t-20.5 -31q21 -13 31 -21.5t16.5 -17.5t13.5 -21t21 -32q23 -32 50 -49.5t50 -25.5v-65 h32v59zM254 326l30 -18t29 -18v-250q-7 0 -13 -0.5t-14 -0.5q-15 0 -32 5v282zM254 672q7 1 14 1.5t15 0.5q17 0 30 -5v-261q-15 10 -30 18.5t-29 17.5v228zM222 466q-29 22 -47 46.5t-18 55.5q0 36 15.5 61t49.5 36v-199z",Size=[1,1]);linear_extrude(200,twist=30)SVG("M344 48v221q36 -26 59.5 -52.5t23.5 -58.5q0 -36 -22.5 -66t-60.5 -44zM254 4q13 -2 20 -2h8h15q8 0 16 1v-58h31v63q35 8 64.5 24.5t50.5 40.5t32.5 54t11.5 65t-13.5 63.5t-35.5 52t-51 44t-59 38.5v267q23 -13 35.5 -31t12.5 -34q0 -25 -5 -45.5t-5 -38.5 q0 -30 17.5 -52.5t49.5 -22.5q9 0 14 1t9.5 3t10 5t14.5 8l-10 25q-3 0 -7 -0.5t-8 -0.5q-11 0 -13 11.5t-1 28.5t4 35t3 32q0 24 -9.5 44t-26 35t-38.5 25.5t-47 16.5v45h-31v-41q-7 1 -12.5 1.5t-11.5 0.5q-10 0 -18.5 -0.5t-16.5 -1.5v41h-32v-45q-68 -15 -104 -61.5 t-36 -121.5q0 -26 11.5 -49.5t31 -44.5t44.5 -41t53 -38v-289q-32 18 -52.5 44t-20.5 46q-1 17 4 30t20 36q-8 3 -16.5 7t-18 10.5t-22 16t-29.5 23.5q-5 -14 -8 -23t-7 -18t-11.5 -21t-20.5 -31q21 -13 31 -21.5t16.5 -17.5t13.5 -21t21 -32q23 -32 50 -49.5t50 -25.5v-65 h32v59zM254 326l30 -18t29 -18v-250q-7 0 -13 -0.5t-14 -0.5q-15 0 -32 5v282zM254 672q7 1 14 1.5t15 0.5q17 0 30 -5v-261q-15 10 -30 18.5t-29 17.5v228zM222 466q-29 22 -47 46.5t-18 55.5q0 36 15.5 61t49.5 36v-199z",Size=[1,1]);

//facebook logo
//SVG("M16 8.049c0-4.446-3.582-8.05-8-8.05C3.58 0-.002 3.603-.002 8.05c0 4.017 2.926 7.347 6.75 7.951v-5.625h-2.03V8.05H6.75V6.275c0-2.017 1.195-3.131 3.022-3.131.876 0 1.791.157 1.791.157v1.98h-1.009c-.993 0-1.303.621-1.303 1.258v1.51h2.218l-.354 2.326H9.25V16c3.824-.604 6.75-3.934 6.75-7.951z",true);

//Copyright - rotation and translation for documentation image
//rotate([0,0,180])translate([100,-100,0])translate([-8,8,0])
//SVG("M256 8C119.033 8 8 119.033 8 256s111.033 248 248 248 248-111.033 248-248S392.967 8 256 8zm0 448c-110.532 0-200-89.451-200-200 0-110.531 89.451-200 200-200 110.532 0 200 89.451 200 200 0 110.532-89.451 200-200 200zm107.351-101.064c-9.614 9.712-45.53 41.396-104.065 41.396-82.43 0-140.484-61.425-140.484-141.567 0-79.152 60.275-139.401 139.762-139.401 55.531 0 88.738 26.62 97.593 34.779a11.965 11.965 0 0 1 1.936 15.322l-18.155 28.113c-3.841 5.95-11.966 7.282-17.499 2.921-8.595-6.776-31.814-22.538-61.708-22.538-48.303 0-77.916 35.33-77.916 80.082 0 41.589 26.888 83.692 78.277 83.692 32.657 0 56.843-19.039 65.726-27.225 5.27-4.857 13.596-4.039 17.82 1.738l19.865 27.17a11.947 11.947 0 0 1-1.152 15.518z",true);

//Wink emoji - rotation and translation for documentation image
//rotate([0,0,90])translate([100,-100,0])
//SVG("M 8 15 A 7 7 0 1 1 8 1 a 7 7 0 0 1 0 14 z m 0 1 A 8 8 0 1 0 8 0 a 8 8 0 0 0 0 16 z M 4.285 9.567 a .5 .5 0 0 1 .683 .183 A 3.498 3.498 0 0 0 8 11.5 a 3.498 3.498 0 0 0 3.032 -1.75 .5 .5 0 1 1 .866 .5 A 4.498 4.498 0 0 1 8 12.5 a 4.498 4.498 0 0 1 -3.898 -2.25 .5 .5 0 0 1 .183 -.683 z M 7 6.5 C 7 7.328 6.552 8 6 8 s -1 -.672 -1 -1.5 S 5.448 5 6 5 s 1 .672 1 1.5 z m 1.757 -.437 a .5 .5 0 0 1 .68 .194 .934 .934 0 0 0 .813 .493 c .339 0 .645 -.19 .813 -.493 a .5 .5 0 1 1 .874 .486 A 1.934 1.934 0 0 1 10.25 7.75 c -.73 0 -1.356 -.412 -1.687 -1.007 a .5 .5 0 0 1 .194 -.68 z",true,[30,30]);

//Thumbs up - rotation and translation for documentation image
//translate([100,-100,0])
//SVG("M 6.956 1.745 C 7.021 .81 7.908 .087 8.864 .325 l .261 .066 c .463 .116 .874 .456 1.012 .964 .22 .817 .533 2.512 .062 4.51 a 9.84 9.84 0 0 1 .443 -.05 c .713 -.065 1.669 -.072 2.516 .21 .518 .173 .994 .68 1.2 1.273 .184 .532 .16 1.162 -.234 1.733 .058 .119 .103 .242 .138 .363 .077 .27 .113 .567 .113 .856 0 .289 -.036 .586 -.113 .856 -.039 .135 -.09 .273 -.16 .404 .169 .387 .107 .819 -.003 1.148 a 3.162 3.162 0 0 1 -.488 .9 c .054 .153 .076 .313 .076 .465 0 .306 -.089 .626 -.253 .912 C 13.1 15.522 12.437 16 11.5 16 H 8 c -.605 0 -1.07 -.081 -1.466 -.218 a 4.826 4.826 0 0 1 -.97 -.484 l -.048 -.03 c -.504 -.307 -.999 -.609 -2.068 -.722 C 2.682 14.464 2 13.846 2 13 V 9 c 0 -.85 .685 -1.432 1.357 -1.616 .849 -.231 1.574 -.786 2.132 -1.41 .56 -.626 .914 -1.279 1.039 -1.638 .199 -.575 .356 -1.54 .428 -2.59 z",true,[30,30]);

//Snowflake - rotation and translation for documentation image
//rotate([0,0,270])translate([100,-100,0])
//SVG("M440.1 355.2l-39.2-23 34.1-9.3c8.4-2.3 13.4-11.1 11.1-19.6l-4.1-15.5c-2.2-8.5-10.9-13.6-19.3-11.3L343 298.2 271.2 256l71.9-42.2 79.7 21.7c8.4 2.3 17-2.8 19.3-11.3l4.1-15.5c2.2-8.5-2.7-17.3-11.1-19.6l-34.1-9.3 39.2-23c7.5-4.4 10.1-14.2 5.8-21.9l-7.9-13.9c-4.3-7.7-14-10.3-21.5-5.9l-39.2 23 9.1-34.7c2.2-8.5-2.7-17.3-11.1-19.6l-15.2-4.1c-8.4-2.3-17 2.8-19.3 11.3l-21.3 81-71.9 42.2v-84.5L306 70.4c6.1-6.2 6.1-16.4 0-22.6l-11.1-11.3c-6.1-6.2-16.1-6.2-22.2 0l-24.9 25.4V16c0-8.8-7-16-15.7-16h-15.7c-8.7 0-15.7 7.2-15.7 16v46.1l-24.9-25.4c-6.1-6.2-16.1-6.2-22.2 0L142.1 48c-6.1 6.2-6.1 16.4 0 22.6l58.3 59.3v84.5l-71.9-42.2-21.3-81c-2.2-8.5-10.9-13.6-19.3-11.3L72.7 84c-8.4 2.3-13.4 11.1-11.1 19.6l9.1 34.7-39.2-23c-7.5-4.4-17.1-1.8-21.5 5.9l-7.9 13.9c-4.3 7.7-1.8 17.4 5.8 21.9l39.2 23-34.1 9.1c-8.4 2.3-13.4 11.1-11.1 19.6L6 224.2c2.2 8.5 10.9 13.6 19.3 11.3l79.7-21.7 71.9 42.2-71.9 42.2-79.7-21.7c-8.4-2.3-17 2.8-19.3 11.3l-4.1 15.5c-2.2 8.5 2.7 17.3 11.1 19.6l34.1 9.3-39.2 23c-7.5 4.4-10.1 14.2-5.8 21.9L10 391c4.3 7.7 14 10.3 21.5 5.9l39.2-23-9.1 34.7c-2.2 8.5 2.7 17.3 11.1 19.6l15.2 4.1c8.4 2.3 17-2.8 19.3-11.3l21.3-81 71.9-42.2v84.5l-58.3 59.3c-6.1 6.2-6.1 16.4 0 22.6l11.1 11.3c6.1 6.2 16.1 6.2 22.2 0l24.9-25.4V496c0 8.8 7 16 15.7 16h15.7c8.7 0 15.7-7.2 15.7-16v-46.1l24.9 25.4c6.1 6.2 16.1 6.2 22.2 0l11.1-11.3c6.1-6.2 6.1-16.4 0-22.6l-58.3-59.3v-84.5l71.9 42.2 21.3 81c2.2 8.5 10.9 13.6 19.3 11.3L375 428c8.4-2.3 13.4-11.1 11.1-19.6l-9.1-34.7 39.2 23c7.5 4.4 17.1 1.8 21.5-5.9l7.9-13.9c4.6-7.5 2.1-17.3-5.5-21.7z",true,$Verbose=true);

//CoffeeToday
//$vpt=[160,-160,0];$vpr=[0,0,0];$vpd=900;Wobble([20,30,0],[0,30,0],[1,2,1])SVG("M102.765,91.563c0.913,0.623,1.979,0.952,3.084,0.952h0.005c3.025,0,5.486-2.461,5.486-5.486c0-0.501-0.069-0.998-0.204-1.481c-1.887-8.316-1.031-14.948,2.543-19.711c4.96-6.605,7.153-15.104,5.868-22.732c-1.149-6.838-4.825-12.522-10.628-16.438c-1.827-1.234-4.306-1.249-6.19,0.035c-1.851,1.28-2.739,3.609-2.216,5.763c2.068,8.823,0.244,14.22-4.627,22.979c-3.33,5.99-4.687,12.734-3.82,18.99C93.055,81.607,96.765,87.537,102.765,91.563",true,$Verbose=false);Wobble([20,30,0],[0,-30,0],[1,1,1])SVG("M151.444,95.421c0.965,0.655,2.095,1.001,3.268,1.001h0.011c3.215,0,5.831-2.614,5.831-5.827 c0-0.547-0.075-1.086-0.223-1.607c-2.695-11.825-1.439-21.313,3.733-28.204c6.484-8.638,9.354-19.733,7.677-29.677c-1.487-8.856-6.248-16.217-13.755-21.278c-1.948-1.321-4.628-1.314-6.578,0.026c-1.985,1.367-2.916,3.769-2.369,6.132c2.918,12.451,0.244,20.377-6.455,32.426c-4.358,7.839-6.136,16.654-5.008,24.821C138.859,82.519,143.661,90.195,151.444,95.421 ",true,$Verbose=false);Wobble([20,30,0],[0,0,0],[1,1,1])SVG("M200.501,91.563c0.913,0.623,1.979,0.952,3.084,0.952h0.005c3.025,0,5.486-2.461,5.486-5.486c0-0.504-0.069-1.002-0.205-1.485c-1.885-8.314-1.029-14.945,2.545-19.707c4.959-6.604,7.153-15.104,5.868-22.732c-1.15-6.838-4.826-12.522-10.628-16.438c-1.828-1.233-4.311-1.246-6.19,0.035c-1.851,1.28-2.739,3.609-2.216,5.763c2.068,8.822,0.244,14.219-4.627,22.979c-3.33,5.989-4.687,12.734-3.821,18.99C190.792,81.607,194.502,87.537,200.501,91.563 ",true,$Verbose=false);SVG("M286.554,235.363c30.169,0,54.714-24.545,54.714-54.714s-24.544-54.714-54.714-54.714c-3.844,0-7.596,0.403-11.218,1.161H31.338c-6.5,0-10.244,2.8-12.241,5.147c-4.089,4.809-4.652,12.008-3.817,17.143c3.513,21.583,13.221,65.331,37.582,101.711c-2.049,0.521-4.066,1.054-6.03,1.609C16.195,261.357,0,272.954,0,286.247s16.195,24.891,46.833,33.54c28.866,8.149,67.184,12.638,107.895,12.638s79.029-4.488,107.895-12.638c30.638-8.649,46.833-20.247,46.833-33.54s-16.195-24.891-46.833-33.54c-1.867-0.527-3.777-1.037-5.722-1.534c3.949-5.917,7.667-12.266,11.146-19.039C273.831,234.22,280.061,235.363,286.554,235.363 M311.268,180.65c0,13.627-11.086,24.714-24.714,24.714c-2.26,0-4.448-0.311-6.529-0.882c5.394-14.878,9.741-30.971,12.866-47.719C303.457,159.568,311.268,169.213,311.268,180.65",true,$Verbose=false);

//Cog - rotation and translation for documentation image
//rotate([0,0,45*$t])translate([256-1024,640,0])
//SVG("M1024 640q0 106 -75 181t-181 75t-181 -75t-75 -181t75 -181t181 -75t181 75t75 181zM1536 749v-222q0 -12 -8 -23t-20 -13l-185 -28q-19 -54 -39 -91q35 -50 107 -138q10 -12 10 -25t-9 -23q-27 -37 -99 -108t-94 -71q-12 0 -26 9l-138 108q-44 -23 -91 -38q-16 -136 -29 -186q-7 -28 -36 -28h-222q-14 0 -24.5 8.5t-11.5 21.5l-28 184q-49 16 -90 37l-141 -107q-10 -9 -25 -9q-14 0 -25 11q-126 114 -165 168q-7 10 -7 23q0 12 8 23q15 21 51 66.5t54 70.5q-27 50 -41 99l-183 27q-13 2 -21 12.5t-8 23.5v222q0 12 8 23t19 13l186 28q14 46 39 92q-40 57 -107 138q-10 12 -10 24q0 10 9 23q26 36 98.5 107.5t94.5 71.5q13 0 26 -10l138 -107q44 23 91 38q16 136 29 186q7 28 36 28h222q14 0 24.5 -8.5t11.5 -21.5l28 -184q49 -16 90 -37l142 107q9 9 24 9q13 0 25 -10q129 -119 165 -170q7 -8 7 -22q0 -12 -8 -23q-15 -21 -51 -66.5t-54 -70.5q26 -50 41 -98l183 -28q13 -2 21 -12.5t8 -23.5z",true,$Verbose=false);

//Circle R
//translate([-8,8,0])
//SVG("M256 8C119.033 8 8 119.033 8 256s111.033 248 248 248 248-111.033 248-248S392.967 8 256 8zm0 448c-110.532 0-200-89.451-200-200 0-110.531 89.451-200 200-200 110.532 0 200 89.451 200 200 0 110.532-89.451 200-200 200zm110.442-81.791c-53.046-96.284-50.25-91.468-53.271-96.085 24.267-13.879 39.482-41.563 39.482-73.176 0-52.503-30.247-85.252-101.498-85.252h-78.667c-6.617 0-12 5.383-12 12V380c0 6.617 5.383 12 12 12h38.568c6.617 0 12-5.383 12-12v-83.663h31.958l47.515 89.303a11.98 11.98 0 0 0 10.593 6.36h42.81c9.14 0 14.914-9.799 10.51-17.791zM256.933 239.906h-33.875v-64.14h27.377c32.417 0 38.929 12.133 38.929 31.709-.001 20.913-11.518 32.431-32.431 32.431z",true);

//Eye
//translate([-300,300])linear_extrude(30,twist=5)
//SVG("M288 144a110.94 110.94 0 0 0-31.24 5 55.4 55.4 0 0 1 7.24 27 56 56 0 0 1-56 56 55.4 55.4 0 0 1-27-7.24A111.71 111.71 0 1 0 288 144zm284.52 97.4C518.29 135.59 410.93 64 288 64S57.68 135.64 3.48 241.41a32.35 32.35 0 0 0 0 29.19C57.71 376.41 165.07 448 288 448s230.32-71.64 284.52-177.41a32.35 32.35 0 0 0 0-29.19zM288 400c-98.65 0-189.09-55-237.93-144C98.91 167 189.34 112 288 112s189.09 55 237.93 144C477.1 345 386.66 400 288 400z",true,$Verbose=false);

//Angry
//SVG("M248 8C111 8 0 119 0 256s111 248 248 248 248-111 248-248S385 8 248 8zm0 448c-110.3 0-200-89.7-200-200S137.7 56 248 56s200 89.7 200 200-89.7 200-200 200zm0-144c-33.6 0-65.2 14.8-86.8 40.6-8.5 10.2-7.1 25.3 3.1 33.8s25.3 7.2 33.8-3c24.8-29.7 75-29.7 99.8 0 8.1 9.7 23.2 11.9 33.8 3 10.2-8.5 11.5-23.6 3.1-33.8-21.6-25.8-53.2-40.6-86.8-40.6zm-48-72c10.3 0 19.9-6.7 23-17.1 3.8-12.7-3.4-26.1-16.1-29.9l-80-24c-12.8-3.9-26.1 3.4-29.9 16.1-3.8 12.7 3.4 26.1 16.1 29.9l28.2 8.5c-3.1 4.9-5.3 10.4-5.3 16.6 0 17.7 14.3 32 32 32s32-14.4 32-32.1zm199-54.9c-3.8-12.7-17.1-19.9-29.9-16.1l-80 24c-12.7 3.8-19.9 17.2-16.1 29.9 3.1 10.4 12.7 17.1 23 17.1 0 17.7 14.3 32 32 32s32-14.3 32-32c0-6.2-2.2-11.7-5.3-16.6l28.2-8.5c12.7-3.7 19.9-17.1 16.1-29.8z",true,$Verbose=false);

//Play-circle
//linear_extrude(50)
//SVG("M371.7 238l-176-107c-15.8-8.8-35.7 2.5-35.7 21v208c0 18.4 19.8 29.8 35.7 21l176-101c16.4-9.1 16.4-32.8 0-42zM504 256C504 119 393 8 256 8S8 119 8 256s111 248 248 248 248-111 248-248zm-448 0c0-110.5 89.5-200 200-200s200 89.5 200 200-89.5 200-200 200S56 366.5 56 256z",true,$Verbose=false);

//Pause-circle
//translate([600,0,0])linear_extrude(50)
//SVG("M256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8zm0 448c-110.5 0-200-89.5-200-200S145.5 56 256 56s200 89.5 200 200-89.5 200-200 200zm96-280v160c0 8.8-7.2 16-16 16h-48c-8.8 0-16-7.2-16-16V176c0-8.8 7.2-16 16-16h48c8.8 0 16 7.2 16 16zm-112 0v160c0 8.8-7.2 16-16 16h-48c-8.8 0-16-7.2-16-16V176c0-8.8 7.2-16 16-16h48c8.8 0 16 7.2 16 16z",true,$Verbose=false);

//Stop-circle
//translate([1200,0])linear_extrude(50)
//SVG("M504 256C504 119 393 8 256 8S8 119 8 256s111 248 248 248 248-111 248-248zm-448 0c0-110.5 89.5-200 200-200s200 89.5 200 200-89.5 200-200 200S56 366.5 56 256zm296-80v160c0 8.8-7.2 16-16 16H176c-8.8 0-16-7.2-16-16V176c0-8.8 7.2-16 16-16h160c8.8 0 16 7.2 16 16z",true,$Verbose=false);

//Cartoony-biplane
//Wobble([20,20,0],[0,90,0])linear_extrude(25)
//SVG("M 341.525,200.731 c 5.631,1.584 11.875,-4.923 13.949,-14.535 2.071,-9.61 -0.812,-18.687 -6.446,-20.272 -5.632,-1.582 -11.878,4.924 -13.95,14.538 -2.071,9.611 0.815,18.685 6.447,20.269 m 0.451,13.052 c 9.575,2.693 20.193,-8.374 23.715,-24.714 3.524,-16.341 -1.38,-31.771 -10.958,-34.462 -9.573,-2.692 -20.192,8.371 -23.714,24.711 -3.524,16.342 1.381,31.773 10.957,34.465 m 171.052,69.502 26.654,-27.662 -34.584,24.947 z M 142.479,474.136 c -5.03,5.086 -19.101,10.451 -29.762,11.647 8.195,8.275 18.097,13.434 27.6,13.434 18.392,0 28.33,-19.318 22.198,-43.149 -6.132,-23.83 -26.011,-43.148 -44.401,-43.148 -18.391,0 -28.33,19.318 -22.198,43.148 1.16,4.509 2.813,8.854 4.853,12.939 3.09,-11.614 10.24,-26.222 15.354,-31.174 1.965,-1.904 4.558,-2.999 7.629,-2.999 9.05,0 18.834,9.507 21.852,21.234 1.963,7.634 0.577,14.326 -3.125,18.068 m 201.814,-246.698 7.081,42.808 -4.463,-43.171 c -0.872,0.189 -1.745,0.313 -2.618,0.363 m -23.355,-6.116 -29.25,92.861 0.661,-1.688 31.359,-89.966 c -0.958,-0.316 -1.881,-0.72 -2.77,-1.207 m -76.735,-31.848 0.183,1.767 69.793,23.914 c -5.827,-8.051 -8.509,-21.189 -6.782,-35.446 l -48.065,-13.514 c -3.477,10.222 -8.935,18.414 -15.129,23.279 m -11.724,4.885 7.081,42.806 -4.464,-43.171 c -0.87,0.192 -1.744,0.314 -2.617,0.365 m -23.354,-6.117 -29.251,92.861 0.66,-1.686 31.361,-89.969 c -0.958,-0.312 -1.882,-0.717 -2.77,-1.206 m 186.103,54.682 116.05,-45.597 -25.58,-3.663 c -24.348,-3.485 -45.74,-2.683 -70.475,2.649 -1.051,-2.547 -2.235,-4.863 -3.511,-6.944 44.547,-8.967 89.507,-12.921 134.319,-11.673 11.058,0.308 20.555,8.214 24.704,20.57 1.569,4.669 2.278,9.688 2.165,14.735 6.82,15.658 12.312,32.57 16.377,50.415 2.687,11.789 -0.775,25.546 -8.358,33.204 -0.753,0.758 -1.514,1.491 -2.28,2.198 l -57.84,-12.868 51.821,17.755 37.502,12.851 c 17.873,6.12 8.207,31.977 -11.495,57.437 l 51.058,17.495 c 46.097,15.795 -66.383,145.248 -112.484,129.453 l -247.682,-84.862 -57.124,41.207 c -0.606,-9.335 -2.159,-19.098 -4.747,-29.154 -6.152,-23.91 -17.276,-46.189 -31.385,-64.908 11.305,17.949 18.427,40.462 19.232,64.908 0.044,1.333 0.069,2.659 0.075,3.978 0.373,1.313 0.73,2.632 1.073,3.958 16.098,62.566 -9.995,113.284 -58.279,113.284 -17.911,0 -36.359,-6.985 -53.303,-18.96 8.238,3.752 17.045,5.8 26.154,5.8 30.041,0 55.344,-22.212 67.057,-54.653 -31.38,18.946 -67.459,12.875 -90.596,-15.528 -3.409,-0.126 -6.06,-0.93 -7.3,-2.651 -1.264,-1.753 -1.392,-5.032 -0.75,-9.079 -17.02,-29.58 -18.539,-69.99 -4.098,-104.67 l 3.375,-7.896 c -29.48,13.799 -49.694,50.829 -48.259,94.353 0.52,15.762 3.825,30.669 9.269,43.934 -7.867,-13.51 -14.114,-28.354 -18.123,-43.934 -16.099,-62.566 9.993,-113.282 58.277,-113.282 4.507,0 9.047,0.442 13.587,1.294 5.27,-1.404 10.748,-2.142 16.385,-2.142 13.546,0 26.466,4.26 37.971,11.803 -16.476,-13.334 -34.64,-22.223 -52.679,-24.909 2.063,-3.527 4.197,-6.999 6.4,-10.407 l -8.853,10.082 c -2.966,-0.348 -5.927,-0.528 -8.873,-0.528 -22.159,0 -39.906,10.078 -51.533,26.879 L 13.885,341.639 C -7.161,334.427 4.856,303.522 28.514,273.566 l 32.543,10.725 15.669,45.528 c 1.531,4.45 8.75,0.703 7.219,-3.97 l -12.502,-38.137 290.753,95.814 -45.573,32.876 50.815,-31.148 121.939,40.183 17.583,51.09 c 1.531,4.451 8.751,0.704 7.22,-3.968 l -14.318,-43.666 14.278,4.704 c 19.081,6.287 47.479,-14.138 68.505,-39.318 l 4.498,16.191 c 1.277,4.596 8.447,0.866 7.217,-3.968 l -5.206,-20.46 -0.121,0.135 c 0.96,-1.29 1.897,-2.587 2.808,-3.887 -24.373,28.252 -59.018,53.231 -79.108,46.347 L 42.382,267.482 C 2.47,253.807 99.86,141.722 139.772,155.397 l 59.027,20.224 c -3.942,-9.409 -4.968,-22.347 -2.088,-35.706 5.082,-23.576 20.402,-39.54 34.217,-35.656 l 14.817,4.168 c 12.571,3.533 19.563,22.294 16.886,43.408 l 47.987,13.495 c 6.425,-19.26 19.867,-31.438 32.123,-27.991 l 14.818,4.165 c 13.814,3.884 20.891,26.146 15.81,49.722 -3.008,13.958 -9.604,25.243 -17.35,31.327 l 0.743,7.193 z");

// === SVG command images ======================================================

//Arc
//P="M 0 0 A 350 100 0 1 1 100 100z";translate([0,0,-3])color(RED)SVG(P);color(BLU)ShowCurve(SVG(P)[0],5,1,true);

//Cubic
//translate([0,0,-3])color(RED)SVG("M 0 0 C 50 0 50 100 100 100 v -100z");color(BLU)ShowCurve(SVG("M 0 0 C 50 0 50 100 100 100z")[0],2,1,true);translate([50,0,0])sphere(r=2);CylinderBetween([0,0],[50,0],Radius=1);translate([50,100,0])sphere(r=2);CylinderBetween([50,100],[100,100],Radius=1);

//Horizontal
//translate([0,0,-3])color(RED)SVG("M 20 0 H 100 Q 60 100 20 0z");color(BLU)BallCylinderBetween([20,0],[100,0],Radius=2);

//Line
//translate([0,0,-3])color(RED)SVG("M 0 0 H 100 L 0 100z");color(BLU)BallCylinderBetween([100,0],[0,100],Radius=2);

//Move
//translate([0,0,-3])color(RED)SVG("M 0 0 100 20 50 50 20 100 M 15 15 65 25 40 40 25 65");color(BLU){ShowCurve([[0,0,0],[100,20,0],[50,50,0],[20,100,0],[0,0,0]],1);ShowCurve([[15,15,0],[65,25,0],[40,40,0],[25,65,0],[15,15,0]],1);}

//Quadratic
//translate([0,0,-3])color(RED)SVG("M 0 0 H 100 L 35 65 Q 0 100 0 50z");color(BLU)ShowCurve(SVG("M 35 65 Q 0 100 0 50")[0],1.5,1,true);/*Quadratic*/translate([0,100,0])sphere(r=1);CylinderBetween([35,65],[0,100],Radius=1);CylinderBetween([0,100],[0,50],Radius=1);


//CubicQuadraticRadiused
//translate([0,0,-3])color(RED)SVG("M 0 0 H 50 C 76 0 82 18 65 35 L 35 65 Q 0 100 0 50z");color(BLU)ShowCurve(SVG("M 35 65 Q 0 100 0 50")[0],1,1,true);/*Quadratic*/translate([0,100,0])sphere(r=1);CylinderBetween([35,65],[0,100],Radius=0.5);CylinderBetween([0,100],[0,50],Radius=0.5);/*Cubic*/translate([76,0,0])sphere(r=1);translate([82,18,0])sphere(r=1);CylinderBetween([50,0],[76,0],Radius=0.5);CylinderBetween([82,18],[65,35],Radius=0.5);color(GRN)ShowCurve(SVG("M 50 0 C 76 0 82 18 65 35")[0],1,1,true);


//Smooth Cubic
//A=360*$t;Q=[50,50]+[cos(A),sin(A)]*30;C=[100,100]-Q;translate([0,0,-3])color(RED)SVG(str("M 0 0 H 100 Q ",Q.x," ",Q.y," 50 50 S 0 100 0 50 z"));color(BLU)ShowCurve(SVG(str("M 50 50 C ",C.x," ",C.y," 0 100 0 50 z"))[0],1,1,true);color(GRN){translate([Q.x,Q.y,0])sphere(r=1);CylinderBetween([50,50],[Q.x,Q.y],Radius=0.5);;CylinderBetween([100,0],[Q.x,Q.y],Radius=0.5);}translate([C.x,C.y,0])sphere(r=1);CylinderBetween([50,50],[C.x,C.y],Radius=0.5);translate([0,100,0])sphere(r=1);CylinderBetween([0,50],[0,100],Radius=0.5);

//Smooth Quadratic (T)
//translate([0,0,-3])color(RED)SVG("M 0 0 H 100 Q 100 80 80 50 T 0 100z");color(BLU)ShowCurve(SVG("M 80 50 Q 60 20 0 100 z")[0],1,1,true);color(GRN){translate([100,80,0])sphere(r=1);CylinderBetween([100,0],[100,80],Radius=0.5);CylinderBetween([100,80],[80,50],Radius=0.5);}translate([60,20,0])sphere(r=1);CylinderBetween([80,50],[60,20],Radius=0.5);CylinderBetween([60,20],[0,100],Radius=0.5);

//Vertical
//translate([0,0,-3])color(RED)SVG("M 0 20 V 100 Q 100 60 0 20z");color(BLU)BallCylinderBetween([0,20],[0,100],Radius=1);

// === Documentation images ====================================================

//SimpleSquare
//translate([0,0,-3])color(RED)SVG("M 0 0 L 100 0 l 0 100 -100 0z");color(BLU){BallCylinderBetween([0,0],[100,0],Radius=1);BallCylinderBetween([100,0],[100,100],Radius=1);BallCylinderBetween([100,100],[0,100],Radius=1);BallCylinderBetween([0,100],[0,0],Radius=1);}

//LargeArcSweepFlags
//Svgc=true;$vpt=[50,-50,0];$vpr=[30,0,0];$vpd=803;color(BLU)ShowCurve(SVG("M 0 0 A 150 100 20 0 0 100 100z",Svgc)[0],3,1,true);color(CYN)ShowCurve(SVG("M 0 0 A 150 100 20 1 0 100 100z",Svgc)[0],3,1,true);color(RED)ShowCurve(SVG("M 0 0 A 150 100 20 0 1 100 100z",Svgc)[0],3,1,true);color(YLW)ShowCurve(SVG("M 0 0 A 150 100 20 1 1 100 100z",Svgc)[0],3,1,true);color(DSG){translate([100,-100,0])sphere(r=6);translate([0,0,0])sphere(r=6);translate([-70,-60,0])SimpleText("LAF=0",15,Thickness=1,Center=false,Font="Noto Mono",Spacing=1);translate([-70,-90,0])SimpleText("SF =0",15,Thickness=1,Center=false,Font="Noto Mono",Spacing=1);translate([-240,-160,0])SimpleText("LAF=1",15,Thickness=1,Center=false,Font="Noto Mono",Spacing=1);translate([-240,-190,0])SimpleText("SF =0",15,Thickness=1,Center=false,Font="Noto Mono",Spacing=1);translate([70,0,0])SimpleText("LAF=0",15,Thickness=1,Center=false,Font="Noto Mono",Spacing=1);translate([70,-30,0])SimpleText("SF =1",15,Thickness=1,Center=false,Font="Noto Mono",Spacing=1);translate([250,80,0])SimpleText("LAF=1",15,Thickness=1,Center=false,Font="Noto Mono",Spacing=1);translate([250,50,0])SimpleText("SF =1",15,Thickness=1,Center=false,Font="Noto Mono",Spacing=1);translate([-100,40,0])SimpleText("Start",15,Thickness=1,Center=false,Font="Noto Mono",Spacing=1);translate([110,-150,0])SimpleText("End",15,Thickness=1,Center=false,Font="Noto Mono",Spacing=1);translate([-180,80,0])SimpleText("X+",15,Thickness=1,Center=false,Font="Noto Mono",Spacing=1);translate([-230,20,0])SimpleText("Y+",15,Thickness=1,Center=false,Font="Noto Mono",Spacing=1);}color(RED)Arrow([50,0,0],Points=[0,10],Thickness=5,Base=[-230,100,0]);color(GRN)Arrow([0,-50*cos(30),-50*sin(30)],Points=[0,10],Thickness=5,Base=[-230,100,0]);
//Foci and center-lines
//color(YLW)ShowCurve([[37.7951, 28.8547], [247.917, -47.6233]],5,Connect=false);color(CYN)ShowCurve([[-147.917, -52.3767], [62.2049, -128.855]],5,Connect=false);color(BLU)translate([142.856, -9.3843])ALine(-20,Thickness=2);color(RED)translate([-42.8559, -90.6157])ALine(-20,Thickness=2);

//rotate_extrude example
//rotate_extrude(angle=180,convexity=10)SVG("M 0 0 L 4 0 C 2 5 5 2 5 6 Q 5 8 2 8 h -2 v -0.5 h 2 Q 4.5 7.5 4.5 6 C 4.5 2.5 1.5 5 3.5 0 ",true);
