/*
  This file belongs in

  <TheGHOUL/DemoFiles/>

  Hank J. van Leuvensteijn Jr. 2021
  theghoul@hankjr.ca
*/

include<TheGHOUL/Config.scad>

/* Cycle through a few ViewPorts: */

ViewPort=ViewPort([
[0,[10,0,0],[0,0,45],50],
[1,[5,0,0],[90,0,-45],50],
[2,[10,0,0],[180,0,45],50],
[3,[5,0,0],[270,0,-45],50],
[4,[10,0,0],[360,0,45],50],
]);

Echo([ViewPort]);

$vpt=ViewPort[1];
$vpr=ViewPort[2];
$vpd=ViewPort[3];

/* Some stuff to look at: */

cube([3,6,2]);

ScreenPosition([6,3,0])
{
    color(DSG)
    sphere(r=4,$fn=200);
    rotate([-60,90,60*sin($t*180)])
    rotate([0,0,-$t*360])
    SimpleBarrelText("It's all relative...",1,4,Helix=0,Thickness=0.1,Center=true,Font="Noto Mono",Spacing=1,Raise=0,Vert=false);
}
