/*
  This file belongs in

  <TheGHOUL/DemoFiles/>

  Hank J. van Leuvensteijn Jr. 2021
  theghoul@hankjr.ca
*/

include<TheGHOUL/Config.scad>

translate([0,0,-5])
linear_extrude(40,center=true)
OvalRing(10,20,1);

render()
difference(){
    union(){
        translate([0,0,15])
        rotate([90,0,0])
        translate([0,0,-40])
        linear_extrude(80)
        Ring(10,1);
        translate([0,40,15])
        rotate([-90,0,0])
        Cap(Ring(10,1));
    }
    translate([0,44,25])
    rotate([0,90,0])
    cylinder(r=10,h=40,center=true);
}

translate([0,0,-15])
rotate([90,0,90])
linear_extrude(60,center=true)
RectangularProfile(40,10,1,3);

color("silver"){
translate([30,0,-15])
rotate([0,90,0])
Cap(RectangularProfile(10,40-Smidge,1,3));

translate([-30,0,-15])
rotate([0,-90,0])
Cap(RectangularProfile(10,40-Smidge,1,3));
}
translate([0,0,-25])
rotate([180,0,90])
Cap(OvalRing(20,10,1));

translate([0,-39,15])
rotate([90,-90,0])
linear_extrude(5)
Star(3,10-Smidge,0.2);
color("silver")
translate([0,-44,15])
rotate([90,-90,0])
StarCap(3,10-Smidge,0.2,2);

color("darkslategrey",0.7)
{

translate([0,-30,15])
rotate([90,0,0])
circle(r=9);

translate([0,30,15])
rotate([90,0,0])
circle(r=9);

}

color("darkslategrey",0.5)
translate([0,0,20])
rotate([90,0,0])
Torus(20)
Ellipse(5,2);

// EOF =========================================================================
